/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.drill.MaskingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringChanger {
    private static final Logger logger = LoggerFactory.getLogger(StringChanger.class);
    private List<MaskingRule> maskingRules = new ArrayList<MaskingRule>();

    public StringChanger(String jsonFilePath) {
        File jsonFile = new File(jsonFilePath);
        if (!jsonFile.exists()) {
            logger.error("Configuration file {} is not found. No one masking rule will be applied.", (Object)jsonFile.getAbsolutePath());
            return;
        }
        if (jsonFile.length() == 0L) {
            logger.info("Configuration file {} is empty. No one masking rule will be applied.", (Object)jsonFile.getAbsolutePath());
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            MaskingRule[] maskingRules = (MaskingRule[])objectMapper.readValue(jsonFile, MaskingRule[].class);
            this.maskingRules = Stream.of(maskingRules).filter(maskingRule -> maskingRule.isActive()).collect(Collectors.toList());
        }
        catch (IOException exception) {
            if (exception instanceof JsonMappingException) {
                logger.error("Configuration file {} has broken format", (Object)jsonFile.getAbsolutePath());
            }
            throw new RuntimeException(exception);
        }
    }

    public String changeString(String strToChange) {
        return this.changeString(strToChange, null);
    }

    public String changeString(String strToChange, String stringOwner) {
        for (MaskingRule maskingRule : this.maskingRules) {
            strToChange = maskingRule.apply(strToChange, stringOwner);
        }
        return strToChange;
    }
}

