/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALPerformanceEvaluation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestDefaultWALProvider {
    private static final Log LOG = LogFactory.getLog(TestDefaultWALProvider.class);
    protected static Configuration conf;
    protected static FileSystem fs;
    protected static FileSystem walFs;
    protected static Path walRootDir;
    protected static final HBaseTestingUtility TEST_UTIL;
    protected MultiVersionConcurrencyControl mvcc;
    @Rule
    public final TestName currentTest = new TestName();
    private static final byte[] UNSPECIFIED_REGION;

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        this.mvcc = new MultiVersionConcurrencyControl();
        for (FileStatus dir : entries = fs.listStatus(new Path("/"))) {
            fs.delete(dir.getPath(), true);
        }
        walFs.delete(walRootDir, true);
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.startMiniDFSCluster(3);
        walRootDir = TEST_UTIL.createWALRootDir();
        conf = TEST_UTIL.getConfiguration();
        fs = FSUtils.getRootDirFileSystem(conf);
        walFs = FSUtils.getWALFileSystem(conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        walFs.delete(walRootDir, true);
        TEST_UTIL.shutdownMiniCluster();
    }

    static String getName() {
        return "TestDefaultWALProvider";
    }

    @Test
    public void testGetServerNameFromWALDirectoryName() throws IOException {
        ServerName sn = ServerName.valueOf("hn", 450, 1398L);
        String hl = walRootDir + "/" + DefaultWALProvider.getWALDirectoryName(sn.toString());
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, null));
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, walRootDir.toUri().toString()));
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, ""));
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, "                  "));
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, hl));
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, hl + "qdf"));
        Assert.assertNull((Object)DefaultWALProvider.getServerNameFromWALDirectoryName(conf, "sfqf" + hl + "qdf"));
        String wals = "/WALs/";
        ServerName parsed = DefaultWALProvider.getServerNameFromWALDirectoryName(conf, walRootDir.toUri().toString() + "/WALs/" + sn + "/localhost%2C32984%2C1343316388997.1343316390417");
        Assert.assertEquals((String)"standard", (Object)sn, (Object)parsed);
        parsed = DefaultWALProvider.getServerNameFromWALDirectoryName(conf, hl + "/qdf");
        Assert.assertEquals((String)"subdir", (Object)sn, (Object)parsed);
        parsed = DefaultWALProvider.getServerNameFromWALDirectoryName(conf, walRootDir.toUri().toString() + "/WALs/" + sn + "-splitting/localhost%3A57020.1340474893931");
        Assert.assertEquals((String)"split", (Object)sn, (Object)parsed);
    }

    protected void addEdits(WAL log, HRegionInfo hri, HTableDescriptor htd, int times) throws IOException {
        byte[] row = Bytes.toBytes("row");
        for (int i = 0; i < times; ++i) {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            cols.add(new KeyValue(row, row, row, timestamp, row));
            log.append(htd, hri, this.getWalKey(hri.getEncodedNameAsBytes(), htd.getTableName(), timestamp), cols, true);
        }
        log.sync();
    }

    WALKey getWalKey(byte[] info, TableName tableName, long timestamp) {
        return new WALKey(info, tableName, timestamp, this.mvcc);
    }

    protected void flushRegion(WAL wal, byte[] regionEncodedName, Set<byte[]> flushedFamilyNames) {
        wal.startCacheFlush(regionEncodedName, flushedFamilyNames);
        wal.completeCacheFlush(regionEncodedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogCleaning() throws Exception {
        LOG.info((Object)"testLogCleaning");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testLogCleaning")).addFamily(new HColumnDescriptor("row"));
        HTableDescriptor htd2 = new HTableDescriptor(TableName.valueOf("testLogCleaning2")).addFamily(new HColumnDescriptor("row"));
        Configuration localConf = new Configuration(conf);
        localConf.set("hbase.wal.provider", DefaultWALProvider.class.getName());
        try (WALFactory wals = new WALFactory(localConf, null, this.currentTest.getMethodName());){
            HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HRegionInfo hri2 = new HRegionInfo(htd2.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            WAL log = wals.getWAL(UNSPECIFIED_REGION, null);
            this.addEdits(log, hri, htd, 1);
            log.rollWriter();
            Assert.assertEquals((long)1L, (long)DefaultWALProvider.getNumRolledLogFiles(log));
            this.addEdits(log, hri, htd, 2);
            log.rollWriter();
            Assert.assertEquals((long)2L, (long)DefaultWALProvider.getNumRolledLogFiles(log));
            this.addEdits(log, hri, htd, 1);
            this.addEdits(log, hri2, htd2, 1);
            this.addEdits(log, hri, htd, 1);
            this.addEdits(log, hri2, htd2, 1);
            log.rollWriter();
            Assert.assertEquals((long)3L, (long)DefaultWALProvider.getNumRolledLogFiles(log));
            this.addEdits(log, hri2, htd2, 1);
            log.startCacheFlush(hri.getEncodedNameAsBytes(), htd.getFamiliesKeys());
            log.completeCacheFlush(hri.getEncodedNameAsBytes());
            log.rollWriter();
            Assert.assertEquals((long)2L, (long)DefaultWALProvider.getNumRolledLogFiles(log));
            this.addEdits(log, hri2, htd2, 1);
            log.startCacheFlush(hri2.getEncodedNameAsBytes(), htd2.getFamiliesKeys());
            log.completeCacheFlush(hri2.getEncodedNameAsBytes());
            log.rollWriter();
            Assert.assertEquals((long)0L, (long)DefaultWALProvider.getNumRolledLogFiles(log));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALArchiving() throws IOException {
        LOG.debug((Object)"testWALArchiving");
        HTableDescriptor table1 = new HTableDescriptor(TableName.valueOf("t1")).addFamily(new HColumnDescriptor("row"));
        HTableDescriptor table2 = new HTableDescriptor(TableName.valueOf("t2")).addFamily(new HColumnDescriptor("row"));
        Configuration localConf = new Configuration(conf);
        localConf.set("hbase.wal.provider", DefaultWALProvider.class.getName());
        try (WALFactory wals = new WALFactory(localConf, null, this.currentTest.getMethodName());){
            WAL wal = wals.getWAL(UNSPECIFIED_REGION, null);
            Assert.assertEquals((long)0L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            HRegionInfo hri1 = new HRegionInfo(table1.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HRegionInfo hri2 = new HRegionInfo(table2.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            hri1.setSplit(false);
            hri2.setSplit(false);
            this.addEdits(wal, hri1, table1, 1);
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            this.addEdits(wal, hri1, table1, 1);
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            this.addEdits(wal, hri1, table1, 3);
            this.flushRegion(wal, hri1.getEncodedNameAsBytes(), table1.getFamiliesKeys());
            wal.rollWriter();
            Assert.assertEquals((long)0L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            this.addEdits(wal, hri2, table2, 1);
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            this.addEdits(wal, hri1, table1, 2);
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            this.addEdits(wal, hri2, table2, 2);
            this.flushRegion(wal, hri1.getEncodedNameAsBytes(), table2.getFamiliesKeys());
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
            this.addEdits(wal, hri2, table2, 2);
            this.flushRegion(wal, hri2.getEncodedNameAsBytes(), table2.getFamiliesKeys());
            wal.rollWriter();
            Assert.assertEquals((long)0L, (long)DefaultWALProvider.getNumRolledLogFiles(wal));
        }
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        int errCode = WALPerformanceEvaluation.innerMain(new Configuration(TEST_UTIL.getConfiguration()), new String[]{"-threads", "3", "-verify", "-noclosefs", "-iterations", "3000"});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setMembershipDedups() throws IOException {
        Configuration localConf = new Configuration(conf);
        localConf.set("hbase.wal.provider", DefaultWALProvider.class.getName());
        try (WALFactory wals = new WALFactory(localConf, null, this.currentTest.getMethodName());){
            HashSet<WAL> seen = new HashSet<WAL>(1);
            Random random = new Random();
            Assert.assertTrue((String)"first attempt to add WAL from default provider should work.", (boolean)seen.add(wals.getWAL(Bytes.toBytes(random.nextInt()), null)));
            for (int i = 0; i < 1000; ++i) {
                Assert.assertFalse((String)"default wal provider is only supposed to return a single wal, which should compare as .equals itself.", (boolean)seen.add(wals.getWAL(Bytes.toBytes(random.nextInt()), null)));
            }
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        UNSPECIFIED_REGION = new byte[0];
    }
}

