/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Use of an atomic type both as monitor and condition variable is intended")
public class TestCompactionArchiveConcurrentClose {
    public HBaseTestingUtility testUtil;
    private Path testDir;
    private AtomicBoolean archived = new AtomicBoolean();

    @Before
    public void setup() throws Exception {
        this.testUtil = HBaseTestingUtility.createLocalHTU();
        this.testDir = this.testUtil.getDataTestDir("TestStoreFileRefresherChore");
        FSUtils.setRootDir(this.testUtil.getConfiguration(), this.testDir);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.cleanupTestDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreCloseAndDischargeRunningInParallel() throws Exception {
        byte[] fam = Bytes.toBytes("f");
        byte[] col = Bytes.toBytes("c");
        byte[] val = Bytes.toBytes("val");
        TableName tableName = TableName.valueOf(this.getClass().getSimpleName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(fam));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        final Region region = this.initHRegion(htd, info);
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<Region> regions = new ArrayList<Region>();
        regions.add(region);
        Mockito.when(rss.getOnlineRegions()).thenReturn(regions);
        final CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, rss, false);
        int batchSize = 10;
        int fileCount = 10;
        for (int f = 0; f < fileCount; ++f) {
            int start;
            for (int i = start = f * batchSize; i < start + batchSize; ++i) {
                Put put = new Put(Bytes.toBytes("row" + i));
                put.addColumn(fam, col, val);
                region.put(put);
            }
            region.flush(true);
        }
        Store store = region.getStore(fam);
        Assert.assertEquals((long)fileCount, (long)store.getStorefilesCount());
        Collection<StoreFile> storefiles = store.getStorefiles();
        for (StoreFile storeFile : storefiles) {
            Assert.assertFalse((boolean)storeFile.isCompactedAway());
        }
        region.compact(true);
        Thread cleanerThread = new Thread(){

            @Override
            public void run() {
                cleaner.chore();
            }
        };
        cleanerThread.start();
        AtomicBoolean atomicBoolean = this.archived;
        synchronized (atomicBoolean) {
            if (!this.archived.get()) {
                this.archived.wait();
            }
        }
        final AtomicReference atomicReference = new AtomicReference();
        Thread closeThread = new Thread(){

            @Override
            public void run() {
                try {
                    ((HRegion)region).close();
                }
                catch (IOException e) {
                    atomicReference.set(e);
                }
            }
        };
        closeThread.start();
        closeThread.join();
        cleanerThread.join();
        if (atomicReference.get() != null) {
            throw (Exception)atomicReference.get();
        }
    }

    private Region initHRegion(HTableDescriptor htd, HRegionInfo info) throws IOException {
        Configuration conf = this.testUtil.getConfiguration();
        Path tableDir = FSUtils.getTableDir(this.testDir, htd.getTableName());
        WaitingHRegionFileSystem fs = new WaitingHRegionFileSystem(conf, tableDir.getFileSystem(conf), tableDir, info);
        Configuration walConf = new Configuration(conf);
        FSUtils.setRootDir(walConf, tableDir);
        WALFactory wals = new WALFactory(walConf, null, "log_" + info.getEncodedName());
        HRegion region = new HRegion(fs, wals.getWAL(info.getEncodedNameAsBytes(), info.getTable().getNamespace()), conf, htd, null);
        region.initialize();
        return region;
    }

    private class WaitingHRegionFileSystem
    extends HRegionFileSystem {
        public WaitingHRegionFileSystem(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo) {
            super(conf, fs, tableDir, regionInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeStoreFiles(String familyName, Collection<StoreFile> storeFiles) throws IOException {
            super.removeStoreFiles(familyName, storeFiles);
            TestCompactionArchiveConcurrentClose.this.archived.set(true);
            AtomicBoolean atomicBoolean = TestCompactionArchiveConcurrentClose.this.archived;
            synchronized (atomicBoolean) {
                TestCompactionArchiveConcurrentClose.this.archived.notifyAll();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted waiting for latch");
            }
        }
    }
}

