/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class})
public class TestCacheOnWriteInSchema {
    private static final Log LOG = LogFactory.getLog(TestCacheOnWriteInSchema.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final String DIR = TEST_UTIL.getDataTestDir("TestCacheOnWriteInSchema").toString();
    private static byte[] table;
    private static byte[] family;
    private static final int NUM_KV = 25000;
    private static final Random rand;
    private static final int NUM_VALID_KEY_TYPES;
    private final CacheOnWriteType cowType;
    private Configuration conf;
    private final String testDescription;
    private HRegion region;
    private HStore store;
    private WALFactory walFactory;
    private FileSystem fs;

    public TestCacheOnWriteInSchema(CacheOnWriteType cowType) {
        this.cowType = cowType;
        this.testDescription = "[cacheOnWrite=" + (Object)((Object)cowType) + "]";
        System.out.println(this.testDescription);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> cowTypes = new ArrayList<Object[]>();
        for (CacheOnWriteType cowType : CacheOnWriteType.values()) {
            cowTypes.add(new Object[]{cowType});
        }
        return cowTypes;
    }

    @Before
    public void setUp() throws IOException {
        table = Bytes.toBytes(this.name.getMethodName().replaceAll("[\\[\\]]", "_"));
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        this.conf.setBoolean("hfile.block.index.cacheonwrite", false);
        this.conf.setBoolean("hfile.block.bloom.cacheonwrite", false);
        this.fs = HFileSystem.get(this.conf);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setBloomFilterType(BloomType.ROWCOL);
        this.cowType.modifyFamilySchema(hcd);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(table));
        htd.addFamily(hcd);
        String id = TestCacheOnWriteInSchema.class.getName();
        Path logdir = new Path(FSUtils.getRootDir(this.conf), DefaultWALProvider.getWALDirectoryName(id));
        this.fs.delete(logdir, true);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.walFactory = new WALFactory(this.conf, null, id);
        this.region = TEST_UTIL.createLocalHRegion(info, htd, this.walFactory.getWAL(info.getEncodedNameAsBytes(), info.getTable().getNamespace()));
        this.store = new HStore(this.region, hcd, this.conf);
    }

    @After
    public void tearDown() throws IOException {
        IOException ex = null;
        try {
            this.region.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Caught Exception", (Throwable)e);
            ex = e;
        }
        try {
            this.walFactory.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Caught Exception", (Throwable)e);
            ex = e;
        }
        try {
            this.fs.delete(new Path(DIR), true);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not delete " + DIR), (Throwable)e);
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Test
    public void testCacheOnWriteInSchema() throws IOException {
        StoreFile.Writer writer = this.store.createWriterInTmp(Integer.MAX_VALUE, HFile.DEFAULT_COMPRESSION_ALGORITHM, false, true, false);
        this.writeStoreFile(writer);
        writer.close();
        this.readStoreFile(writer.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStoreFile(Path path) throws IOException {
        CacheConfig cacheConf = this.store.getCacheConfig();
        BlockCache cache = cacheConf.getBlockCache();
        StoreFile sf = new StoreFile(this.fs, path, this.conf, cacheConf, BloomType.ROWCOL);
        try (HFileReaderV2 reader = (HFileReaderV2)sf.createReader().getHFileReader();){
            HFileBlock block;
            HFileScanner scanner = reader.getScanner(false, false);
            Assert.assertTrue((String)this.testDescription, (boolean)scanner.seekTo());
            for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
                block = reader.readBlock(offset, -1L, false, true, false, true, null, DataBlockEncoding.NONE);
                BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
                boolean isCached = cache.getBlock(blockCacheKey, true, false, true) != null;
                boolean shouldBeCached = this.cowType.shouldBeCached(block.getBlockType());
                if (shouldBeCached != isCached) {
                    throw new AssertionError((Object)("shouldBeCached: " + shouldBeCached + "\nisCached: " + isCached + "\nTest description: " + this.testDescription + "\nblock: " + block + "\nblockCacheKey: " + blockCacheKey));
                }
            }
        }
    }

    private static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + (Object)((Object)keyType) + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private void writeStoreFile(StoreFile.Writer writer) throws IOException {
        int rowLen = 32;
        for (int i = 0; i < 25000; ++i) {
            byte[] k = TestHFileWriterV2.randomOrderedKey(rand, i);
            byte[] v = TestHFileWriterV2.randomValue(rand);
            int cfLen = rand.nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, rand.nextLong(), TestCacheOnWriteInSchema.generateKeyType(rand), v, 0, v.length);
            writer.append(kv);
        }
    }

    static {
        family = Bytes.toBytes("family");
        rand = new Random(12983177L);
        NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    }

    private static enum CacheOnWriteType {
        DATA_BLOCKS(BlockType.DATA, BlockType.ENCODED_DATA),
        BLOOM_BLOCKS(BlockType.BLOOM_CHUNK),
        INDEX_BLOCKS(BlockType.LEAF_INDEX, BlockType.INTERMEDIATE_INDEX);

        private final BlockType blockType1;
        private final BlockType blockType2;

        private CacheOnWriteType(BlockType blockType) {
            this(blockType, blockType);
        }

        private CacheOnWriteType(BlockType blockType1, BlockType blockType2) {
            this.blockType1 = blockType1;
            this.blockType2 = blockType2;
        }

        public boolean shouldBeCached(BlockType blockType) {
            return blockType == this.blockType1 || blockType == this.blockType2;
        }

        public void modifyFamilySchema(HColumnDescriptor family) {
            switch (this) {
                case DATA_BLOCKS: {
                    family.setCacheDataOnWrite(true);
                    break;
                }
                case BLOOM_BLOCKS: {
                    family.setCacheBloomsOnWrite(true);
                    break;
                }
                case INDEX_BLOCKS: {
                    family.setCacheIndexesOnWrite(true);
                }
            }
        }
    }
}

