/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import drill.shaded.hbase.guava.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class RegionSplitPolicy
extends Configured {
    private static final Class<? extends RegionSplitPolicy> DEFAULT_SPLIT_POLICY_CLASS = IncreasingToUpperBoundRegionSplitPolicy.class;
    protected HRegion region;

    protected void configureForRegion(HRegion region) {
        Preconditions.checkState((this.region == null ? 1 : 0) != 0, (String)"Policy already configured for region {}", (Object)this.region);
        this.region = region;
    }

    protected abstract boolean shouldSplit();

    protected byte[] getSplitPoint() {
        byte[] explicitSplitPoint = this.region.getExplicitSplitPoint();
        if (explicitSplitPoint != null) {
            return explicitSplitPoint;
        }
        List<Store> stores = this.region.getStores();
        byte[] splitPointFromLargestStore = null;
        long largestStoreSize = 0L;
        for (Store s : stores) {
            byte[] splitPoint = s.getSplitPoint();
            long storeSize = s.getSize();
            if (splitPoint == null || largestStoreSize >= storeSize) continue;
            splitPointFromLargestStore = splitPoint;
            largestStoreSize = storeSize;
        }
        return splitPointFromLargestStore;
    }

    public static RegionSplitPolicy create(HRegion region, Configuration conf) throws IOException {
        Class<? extends RegionSplitPolicy> clazz = RegionSplitPolicy.getSplitPolicyClass(region.getTableDesc(), conf);
        RegionSplitPolicy policy = (RegionSplitPolicy)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        policy.configureForRegion(region);
        return policy;
    }

    public static Class<? extends RegionSplitPolicy> getSplitPolicyClass(HTableDescriptor htd, Configuration conf) throws IOException {
        String className = htd.getRegionSplitPolicyClassName();
        if (className == null) {
            className = conf.get("hbase.regionserver.region.split.policy", DEFAULT_SPLIT_POLICY_CLASS.getName());
        }
        try {
            Class<RegionSplitPolicy> clazz = Class.forName(className).asSubclass(RegionSplitPolicy.class);
            return clazz;
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured region split policy '" + className + "' for table '" + htd.getTableName() + "'", e);
        }
    }

    @Deprecated
    protected boolean skipStoreFileRangeCheck() {
        return false;
    }

    protected boolean skipStoreFileRangeCheck(String familyName) {
        return this.skipStoreFileRangeCheck();
    }
}

