/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestDeleteColumnFamilyProcedureFromClient {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLENAME = TableName.valueOf("column_family_handlers");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("cf1"), Bytes.toBytes("cf2"), Bytes.toBytes("cf3")};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        TEST_UTIL.createTable(TABLENAME, FAMILIES);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        TEST_UTIL.loadTable((Table)t, FAMILIES);
        TEST_UTIL.flush();
        t.close();
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @After
    public void cleanup() throws Exception {
        TEST_UTIL.deleteTable(TABLENAME);
    }

    @Test
    public void deleteColumnFamilyWithMultipleRegions() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor beforehtd = admin.getTableDescriptor(TABLENAME);
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        Assert.assertTrue((boolean)admin.isTableAvailable(TABLENAME));
        Assert.assertEquals((long)3L, (long)beforehtd.getColumnFamilies().length);
        HColumnDescriptor[] families = beforehtd.getColumnFamilies();
        for (int i = 0; i < families.length; ++i) {
            Assert.assertTrue((boolean)families[i].getNameAsString().equals("cf" + (i + 1)));
        }
        Path tableDir = FSUtils.getTableDir(TEST_UTIL.getDefaultRootDirPath(), TABLENAME);
        Assert.assertTrue((boolean)fs.exists(tableDir));
        FileStatus[] fileStatus = fs.listStatus(tableDir);
        for (int i = 0; i < fileStatus.length; ++i) {
            if (!fileStatus[i].isDirectory()) continue;
            FileStatus[] cf = fs.listStatus(fileStatus[i].getPath(), new PathFilter(){

                public boolean accept(Path p) {
                    return !p.getName().contains("recovered.edits");
                }
            });
            int k = 1;
            for (int j = 0; j < cf.length; ++j) {
                if (!cf[j].isDirectory() || cf[j].getPath().getName().startsWith(".")) continue;
                Assert.assertEquals((Object)cf[j].getPath().getName(), (Object)("cf" + k));
                ++k;
            }
        }
        admin.disableTable(TABLENAME);
        admin.deleteColumn(TABLENAME, Bytes.toBytes("cf2"));
        HTableDescriptor afterhtd = admin.getTableDescriptor(TABLENAME);
        Assert.assertEquals((long)2L, (long)afterhtd.getColumnFamilies().length);
        HColumnDescriptor[] newFamilies = afterhtd.getColumnFamilies();
        Assert.assertTrue((boolean)newFamilies[0].getNameAsString().equals("cf1"));
        Assert.assertTrue((boolean)newFamilies[1].getNameAsString().equals("cf3"));
        fileStatus = fs.listStatus(tableDir);
        for (int i = 0; i < fileStatus.length; ++i) {
            if (!fileStatus[i].isDirectory()) continue;
            FileStatus[] cf = fs.listStatus(fileStatus[i].getPath(), new PathFilter(){

                public boolean accept(Path p) {
                    return !WALSplitter.isSequenceIdFile(p);
                }
            });
            for (int j = 0; j < cf.length; ++j) {
                if (!cf[j].isDirectory()) continue;
                Assert.assertFalse((boolean)cf[j].getPath().getName().equals("cf2"));
            }
        }
    }

    @Test
    public void deleteColumnFamilyTwice() throws Exception {
        int j;
        FileStatus[] cf;
        int i;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor beforehtd = admin.getTableDescriptor(TABLENAME);
        String cfToDelete = "cf1";
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        Assert.assertTrue((boolean)admin.isTableAvailable(TABLENAME));
        HColumnDescriptor[] families = beforehtd.getColumnFamilies();
        Boolean foundCF = false;
        for (int i2 = 0; i2 < families.length; ++i2) {
            if (!families[i2].getNameAsString().equals(cfToDelete)) continue;
            foundCF = true;
            break;
        }
        Assert.assertTrue((boolean)foundCF);
        Path tableDir = FSUtils.getTableDir(TEST_UTIL.getDefaultRootDirPath(), TABLENAME);
        Assert.assertTrue((boolean)fs.exists(tableDir));
        FileStatus[] fileStatus = fs.listStatus(tableDir);
        foundCF = false;
        for (i = 0; i < fileStatus.length; ++i) {
            if (fileStatus[i].isDirectory()) {
                cf = fs.listStatus(fileStatus[i].getPath(), new PathFilter(){

                    public boolean accept(Path p) {
                        return !p.getName().contains("recovered.edits");
                    }
                });
                for (j = 0; j < cf.length; ++j) {
                    if (!cf[j].isDirectory() || !cf[j].getPath().getName().equals(cfToDelete)) continue;
                    foundCF = true;
                    break;
                }
            }
            if (foundCF.booleanValue()) break;
        }
        Assert.assertTrue((boolean)foundCF);
        if (admin.isTableEnabled(TABLENAME)) {
            admin.disableTable(TABLENAME);
        }
        admin.deleteColumn(TABLENAME, Bytes.toBytes(cfToDelete));
        fileStatus = fs.listStatus(tableDir);
        for (i = 0; i < fileStatus.length; ++i) {
            if (!fileStatus[i].isDirectory()) continue;
            cf = fs.listStatus(fileStatus[i].getPath(), new PathFilter(){

                public boolean accept(Path p) {
                    return !WALSplitter.isSequenceIdFile(p);
                }
            });
            for (j = 0; j < cf.length; ++j) {
                if (!cf[j].isDirectory()) continue;
                Assert.assertFalse((boolean)cf[j].getPath().getName().equals(cfToDelete));
            }
        }
        try {
            admin.deleteColumn(TABLENAME, Bytes.toBytes(cfToDelete));
            Assert.fail((String)"Delete a non-exist column family should fail");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
    }
}

