/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClockSkewDetection {
    private static final Log LOG = LogFactory.getLog(TestClockSkewDetection.class);

    @Test
    public void testClockSkewDetection() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        ServerManager sm = new ServerManager(new Server(){

            @Override
            public ClusterConnection getConnection() {
                return null;
            }

            @Override
            public MetaTableLocator getMetaTableLocator() {
                return null;
            }

            @Override
            public Configuration getConfiguration() {
                return conf;
            }

            @Override
            public ServerName getServerName() {
                return null;
            }

            @Override
            public ZooKeeperWatcher getZooKeeper() {
                return null;
            }

            @Override
            public CoordinatedStateManager getCoordinatedStateManager() {
                return null;
            }

            @Override
            public void abort(String why, Throwable e) {
            }

            @Override
            public boolean isAborted() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return false;
            }

            @Override
            public void stop(String why) {
            }

            @Override
            public ChoreService getChoreService() {
                return null;
            }
        }, null, false);
        LOG.debug((Object)"regionServerStartup 1");
        InetAddress ia1 = InetAddress.getLocalHost();
        RegionServerStatusProtos.RegionServerStartupRequest.Builder request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
        request.setPort(1234);
        request.setServerStartCode(-1L);
        request.setServerCurrentTime(System.currentTimeMillis());
        sm.regionServerStartup(request.build(), ia1);
        Configuration c = HBaseConfiguration.create();
        long maxSkew = c.getLong("hbase.master.maxclockskew", 30000L);
        long warningSkew = c.getLong("hbase.master.warningclockskew", 1000L);
        try {
            LOG.debug((Object)"Test: Master Time > Region Server Time");
            LOG.debug((Object)"regionServerStartup 2");
            InetAddress ia2 = InetAddress.getLocalHost();
            request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            request.setPort(1235);
            request.setServerStartCode(-1L);
            request.setServerCurrentTime(System.currentTimeMillis() - maxSkew * 2L);
            sm.regionServerStartup(request.build(), ia2);
            Assert.fail((String)"HMaster should have thrown a ClockOutOfSyncException but didn't.");
        }
        catch (ClockOutOfSyncException e) {
            LOG.info((Object)("Received expected exception: " + e));
        }
        try {
            LOG.debug((Object)"Test: Master Time < Region Server Time");
            LOG.debug((Object)"regionServerStartup 3");
            InetAddress ia3 = InetAddress.getLocalHost();
            request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            request.setPort(1236);
            request.setServerStartCode(-1L);
            request.setServerCurrentTime(System.currentTimeMillis() + maxSkew * 2L);
            sm.regionServerStartup(request.build(), ia3);
            Assert.fail((String)"HMaster should have thrown a ClockOutOfSyncException but didn't.");
        }
        catch (ClockOutOfSyncException e) {
            LOG.info((Object)("Received expected exception: " + e));
        }
        LOG.debug((Object)"regionServerStartup 4");
        InetAddress ia4 = InetAddress.getLocalHost();
        request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
        request.setPort(1237);
        request.setServerStartCode(-1L);
        request.setServerCurrentTime(System.currentTimeMillis() - warningSkew * 2L);
        sm.regionServerStartup(request.build(), ia4);
        LOG.debug((Object)"regionServerStartup 5");
        InetAddress ia5 = InetAddress.getLocalHost();
        request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
        request.setPort(1238);
        request.setServerStartCode(-1L);
        request.setServerCurrentTime(System.currentTimeMillis() + warningSkew * 2L);
        sm.regionServerStartup(request.build(), ia5);
    }
}

