/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCatalogJanitorInMemoryStates {
    private static final Log LOG = LogFactory.getLog(TestCatalogJanitorInMemoryStates.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public final TestName name = new TestName();
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[] VALUE = Bytes.toBytes("testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testInMemoryParentCleanup() throws IOException, InterruptedException {
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        ServerManager sm = TEST_UTIL.getHBaseCluster().getMaster().getServerManager();
        CatalogJanitor janitor = TestCatalogJanitorInMemoryStates.TEST_UTIL.getHBaseCluster().getMaster().catalogJanitorChore;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.enableCatalogJanitor(false);
        TableName tableName = TableName.valueOf(this.name.getMethodName());
        HTable t = TEST_UTIL.createTable(tableName, FAMILY);
        int rowCount = TEST_UTIL.loadTable((Table)t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        List<HRegionLocation> allRegionLocations = locator.getAllRegionLocations();
        HRegionLocation parent = allRegionLocations.get(0);
        List<HRegionLocation> daughters = this.splitRegion(parent.getRegionInfo());
        LOG.info((Object)("Parent region: " + parent));
        LOG.info((Object)("Daughter regions: " + daughters));
        Assert.assertNotNull((String)("Should have found daughter regions for " + parent), daughters);
        Assert.assertTrue((String)"Parent region should exist in RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates(parent.getRegionInfo()));
        Assert.assertTrue((String)"Parent region should exist in ServerManager", (boolean)sm.isRegionInServerManagerStates(parent.getRegionInfo()));
        Result r = MetaMockingUtil.getMetaTableRowResult(parent.getRegionInfo(), null, daughters.get(0).getRegionInfo(), daughters.get(1).getRegionInfo());
        Thread.sleep(5000L);
        janitor.cleanParent(parent.getRegionInfo(), r);
        Thread.sleep(5000L);
        Assert.assertFalse((String)"Parent region should have been removed from RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates(parent.getRegionInfo()));
        Assert.assertFalse((String)"Parent region should have been removed from ServerManager", (boolean)sm.isRegionInServerManagerStates(parent.getRegionInfo()));
    }

    @Test(timeout=180000L)
    public void testInMemoryForReplicaParentCleanup() throws Exception {
        final AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        CatalogJanitor janitor = TestCatalogJanitorInMemoryStates.TEST_UTIL.getHBaseCluster().getMaster().catalogJanitorChore;
        TableName tableName = TableName.valueOf("testInMemoryForReplicaParentCleanup");
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor(tableName.getNameAsString());
        hdt.setRegionReplication(2);
        TEST_UTIL.createTable(hdt, (byte[][])new byte[][]{FAMILY}, TEST_UTIL.getConfiguration());
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        List<HRegionLocation> allRegionLocations = locator.getAllRegionLocations();
        Assert.assertTrue((allRegionLocations.size() == 2 ? 1 : 0) != 0);
        final HRegionLocation primaryParentRegion = RegionReplicaUtil.isDefaultReplica(allRegionLocations.get(0).getRegionInfo().getReplicaId()) ? allRegionLocations.get(0) : allRegionLocations.get(1);
        final HRegionLocation replicaParentRegion = RegionReplicaUtil.isDefaultReplica(allRegionLocations.get(0).getRegionInfo().getReplicaId()) ? allRegionLocations.get(1) : allRegionLocations.get(0);
        Assert.assertNotNull((String)("Should have found daughter regions for " + primaryParentRegion), this.splitRegion(primaryParentRegion.getRegionInfo(), Bytes.toBytes("a")));
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return !am.getRegionStates().existsInServerHoldings(primaryParentRegion.getServerName(), primaryParentRegion.getRegionInfo()) && !am.getRegionStates().existsInServerHoldings(replicaParentRegion.getServerName(), replicaParentRegion.getRegionInfo());
            }
        });
    }

    private List<HRegionLocation> splitRegion(HRegionInfo r) throws IOException, InterruptedException {
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        Connection connection = TEST_UTIL.getConnection();
        admin.splitRegion(r.getEncodedNameAsBytes());
        admin.close();
        PairOfSameType<HRegionInfo> regions = this.waitOnDaughters(r);
        if (regions != null) {
            try (RegionLocator rl = connection.getRegionLocator(r.getTable());){
                locations.add(rl.getRegionLocation(regions.getFirst().getEncodedNameAsBytes()));
                locations.add(rl.getRegionLocation(regions.getSecond().getEncodedNameAsBytes()));
            }
            return locations;
        }
        return locations;
    }

    private List<HRegionLocation> splitRegion(HRegionInfo r, byte[] splitPoint) throws IOException, InterruptedException {
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        Connection connection = TEST_UTIL.getConnection();
        admin.splitRegion(r.getEncodedNameAsBytes(), splitPoint);
        admin.close();
        PairOfSameType<HRegionInfo> regions = this.waitOnDaughters(r);
        if (regions != null) {
            try (RegionLocator rl = connection.getRegionLocator(r.getTable());){
                locations.add(rl.getRegionLocation(regions.getFirst().getEncodedNameAsBytes()));
                locations.add(rl.getRegionLocation(regions.getSecond().getEncodedNameAsBytes()));
            }
            return locations;
        }
        return locations;
    }

    /*
     * Exception decompiling
     */
    private PairOfSameType<HRegionInfo> waitOnDaughters(HRegionInfo r) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

