/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IdentityTableReducer;
import org.apache.hadoop.hbase.mapreduce.MultithreadedTableMapper;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMultithreadedTableMapper {
    private static final Log LOG = LogFactory.getLog(TestMultithreadedTableMapper.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final TableName MULTI_REGION_TABLE_NAME = TableName.valueOf("mrtest");
    static final byte[] INPUT_FAMILY = Bytes.toBytes("contents");
    static final byte[] OUTPUT_FAMILY = Bytes.toBytes("text");
    static final int NUMBER_OF_THREADS = 10;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        UTIL.setJobWithoutMRCluster();
        UTIL.startMiniCluster();
        HTable table = UTIL.createMultiRegionTable(MULTI_REGION_TABLE_NAME, new byte[][]{INPUT_FAMILY, OUTPUT_FAMILY});
        UTIL.loadTable((Table)table, INPUT_FAMILY, false);
        UTIL.waitUntilAllRegionsAssigned(MULTI_REGION_TABLE_NAME);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultithreadedTableMapper() throws IOException, InterruptedException, ClassNotFoundException {
        this.runTestOnTable(new HTable(new Configuration(UTIL.getConfiguration()), MULTI_REGION_TABLE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestOnTable(HTable table) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = null;
        try {
            LOG.info((Object)"Before map/reduce startup");
            job = new Job(table.getConfiguration(), "process column contents");
            job.setNumReduceTasks(1);
            Scan scan = new Scan();
            scan.addFamily(INPUT_FAMILY);
            TableMapReduceUtil.initTableMapperJob(table.getTableName(), scan, MultithreadedTableMapper.class, ImmutableBytesWritable.class, Put.class, job);
            MultithreadedTableMapper.setMapperClass(job, ProcessContentsMapper.class);
            MultithreadedTableMapper.setNumberOfThreads(job, 10);
            TableMapReduceUtil.initTableReducerJob(Bytes.toString(table.getTableName()), IdentityTableReducer.class, job);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path("test"));
            LOG.info((Object)("Started " + table.getName().getNameAsString()));
            Assert.assertTrue((boolean)job.waitForCompletion(true));
            LOG.info((Object)"After map/reduce completion");
            this.verify(table.getName());
        }
        finally {
            table.close();
            if (job != null) {
                FileUtil.fullyDelete((File)new File(job.getConfiguration().get("hadoop.tmp.dir")));
            }
        }
    }

    private void verify(TableName tableName) throws IOException {
        HTable table = new HTable(new Configuration(UTIL.getConfiguration()), tableName);
        boolean verified = false;
        long pause = UTIL.getConfiguration().getLong("hbase.client.pause", 5000L);
        int numRetries = UTIL.getConfiguration().getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                LOG.info((Object)("Verification attempt #" + i));
                this.verifyAttempt(table);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                LOG.debug((Object)("Verification attempt failed: " + e.getMessage()));
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        Assert.assertTrue((boolean)verified);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAttempt(Table table) throws IOException, NullPointerException {
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILY);
        scan.addFamily(OUTPUT_FAMILY);
        try (ResultScanner scanner = table.getScanner(scan);){
            Iterator itr = scanner.iterator();
            Assert.assertTrue((boolean)itr.hasNext());
            while (itr.hasNext()) {
                Result r = (Result)itr.next();
                if (LOG.isDebugEnabled() && r.size() > 2) {
                    throw new IOException("Too many results, expected 2 got " + r.size());
                }
                byte[] firstValue = null;
                byte[] secondValue = null;
                int count = 0;
                for (Cell kv : r.listCells()) {
                    if (count == 0) {
                        firstValue = CellUtil.cloneValue(kv);
                    } else if (count == 1) {
                        secondValue = CellUtil.cloneValue(kv);
                    } else if (count == 2) break;
                    ++count;
                }
                String first = "";
                if (firstValue == null) {
                    throw new NullPointerException(Bytes.toString(r.getRow()) + ": first value is null");
                }
                first = Bytes.toString(firstValue);
                String second = "";
                if (secondValue == null) {
                    throw new NullPointerException(Bytes.toString(r.getRow()) + ": second value is null");
                }
                byte[] secondReversed = new byte[secondValue.length];
                int i = 0;
                int j = secondValue.length - 1;
                while (j >= 0) {
                    secondReversed[i] = secondValue[j];
                    --j;
                    ++i;
                }
                second = Bytes.toString(secondReversed);
                if (first.compareTo(second) == 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("second key is not the reverse of first. row=" + Bytes.toStringBinary(r.getRow()) + ", first value=" + first + ", second value=" + second));
                }
                Assert.fail();
            }
        }
    }

    public static class ProcessContentsMapper
    extends TableMapper<ImmutableBytesWritable, Put> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString(INPUT_FAMILY) + "'.");
            }
            String originalValue = Bytes.toString(value.getValue(INPUT_FAMILY, INPUT_FAMILY));
            StringBuilder newValue = new StringBuilder(originalValue);
            newValue.reverse();
            Put outval = new Put(key.get());
            outval.add(OUTPUT_FAMILY, null, Bytes.toBytes(newValue.toString()));
            context.write((Object)key, (Object)outval);
        }
    }
}

