/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import drill.shaded.hbase.guava.com.google.common.base.Preconditions;
import java.util.HashMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class LRUDictionary
implements Dictionary {
    BidirectionalLRUMap backingStore;

    @Override
    public byte[] getEntry(short idx) {
        return this.backingStore.get(idx);
    }

    @Override
    public void init(int initialSize) {
        this.backingStore = new BidirectionalLRUMap(initialSize);
    }

    @Override
    public short findEntry(byte[] data, int offset, int length) {
        short ret = this.backingStore.findIdx(data, offset, length);
        if (ret == -1) {
            this.addEntry(data, offset, length);
        }
        return ret;
    }

    @Override
    public short addEntry(byte[] data, int offset, int length) {
        if (length <= 0) {
            return -1;
        }
        return this.backingStore.put(data, offset, length);
    }

    @Override
    public void clear() {
        this.backingStore.clear();
    }

    static class BidirectionalLRUMap {
        private int currSize = 0;
        private Node head;
        private Node tail;
        private HashMap<Node, Short> nodeToIndex = new HashMap();
        private Node[] indexToNode;
        private int initSize = 0;

        public BidirectionalLRUMap(int initialSize) {
            this.initSize = initialSize;
            this.indexToNode = new Node[initialSize];
        }

        private short put(byte[] array, int offset, int length) {
            byte[] stored = new byte[length];
            Bytes.putBytes(stored, 0, array, offset, length);
            if (this.currSize < this.initSize) {
                if (this.indexToNode[this.currSize] == null) {
                    this.indexToNode[this.currSize] = new Node();
                }
                this.indexToNode[this.currSize].setContents(stored, 0, stored.length);
                this.setHead(this.indexToNode[this.currSize]);
                short ret = (short)this.currSize++;
                this.nodeToIndex.put(this.indexToNode[ret], ret);
                return ret;
            }
            short s = this.nodeToIndex.remove(this.tail);
            this.tail.setContents(stored, 0, stored.length);
            this.nodeToIndex.put(this.tail, s);
            this.moveToHead(this.tail);
            return s;
        }

        private short findIdx(byte[] array, int offset, int length) {
            Node comparisonNode = new Node();
            comparisonNode.setContents(array, offset, length);
            Short s = this.nodeToIndex.get(comparisonNode);
            if (s != null) {
                this.moveToHead(this.indexToNode[s]);
                return s;
            }
            return -1;
        }

        private byte[] get(short idx) {
            Preconditions.checkElementIndex(idx, this.currSize);
            this.moveToHead(this.indexToNode[idx]);
            return this.indexToNode[idx].container;
        }

        private void moveToHead(Node n) {
            if (this.head.equals(n)) {
                return;
            }
            assert (n.prev != null);
            n.prev.next = n.next;
            if (n.next != null) {
                n.next.prev = n.prev;
            } else {
                assert (n.equals(this.tail));
                this.tail = n.prev;
            }
            this.setHead(n);
        }

        private void setHead(Node n) {
            n.prev = null;
            n.next = this.head;
            if (this.head != null) {
                assert (this.head.prev == null);
                this.head.prev = n;
            }
            this.head = n;
            if (this.tail == null) {
                this.tail = n;
            }
        }

        private void clear() {
            for (int i = 0; i < this.currSize; ++i) {
                this.indexToNode[i].next = null;
                this.indexToNode[i].prev = null;
                this.indexToNode[i].container = null;
            }
            this.currSize = 0;
            this.nodeToIndex.clear();
            this.tail = null;
            this.head = null;
        }

        private static class Node {
            byte[] container;
            int offset;
            int length;
            Node next;
            Node prev;

            private void setContents(byte[] container, int offset, int length) {
                this.container = container;
                this.offset = offset;
                this.length = length;
            }

            public int hashCode() {
                return Bytes.hashCode(this.container, this.offset, this.length);
            }

            public boolean equals(Object other) {
                if (!(other instanceof Node)) {
                    return false;
                }
                Node casted = (Node)other;
                return Bytes.equals(this.container, this.offset, this.length, casted.container, casted.offset, casted.length);
            }
        }
    }
}

