/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TagUsage;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestSeekTo {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final DataBlockEncoding encoding;
    static boolean switchKVs = false;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            paramList.add(new Object[]{encoding});
        }
        return paramList;
    }

    public TestSeekTo(DataBlockEncoding encoding) {
        this.encoding = encoding;
    }

    @Before
    public void setUp() {
        switchKVs = false;
    }

    static KeyValue toKV(String row, TagUsage tagUsage) {
        if (tagUsage == TagUsage.NO_TAG) {
            return new KeyValue(Bytes.toBytes(row), Bytes.toBytes("family"), Bytes.toBytes("qualifier"), Bytes.toBytes("value"));
        }
        if (tagUsage == TagUsage.ONLY_TAG) {
            Tag t = new Tag(1, "myTag1");
            Tag[] tags = new Tag[]{t};
            return new KeyValue(Bytes.toBytes(row), Bytes.toBytes("family"), Bytes.toBytes("qualifier"), Long.MAX_VALUE, Bytes.toBytes("value"), tags);
        }
        if (!switchKVs) {
            switchKVs = true;
            return new KeyValue(Bytes.toBytes(row), Bytes.toBytes("family"), Bytes.toBytes("qualifier"), Long.MAX_VALUE, Bytes.toBytes("value"));
        }
        switchKVs = false;
        Tag t = new Tag(1, "myTag1");
        Tag[] tags = new Tag[]{t};
        return new KeyValue(Bytes.toBytes(row), Bytes.toBytes("family"), Bytes.toBytes("qualifier"), Long.MAX_VALUE, Bytes.toBytes("value"), tags);
    }

    static String toRowStr(Cell kv) {
        return Bytes.toString(KeyValueUtil.ensureKeyValue(kv).getRow());
    }

    Path makeNewFile(TagUsage tagUsage) throws IOException {
        Path ncTFile = new Path(TEST_UTIL.getDataTestDir(), "basic.hfile");
        FSDataOutputStream fout = TEST_UTIL.getTestFileSystem().create(ncTFile);
        Configuration conf = TEST_UTIL.getConfiguration();
        if (tagUsage != TagUsage.NO_TAG) {
            conf.setInt("hfile.format.version", 3);
        } else {
            conf.setInt("hfile.format.version", 2);
        }
        int blocksize = TestSeekTo.toKV("a", tagUsage).getLength() * 3;
        HFileContext context = new HFileContextBuilder().withBlockSize(blocksize).withDataBlockEncoding(this.encoding).withIncludesTags(true).build();
        HFile.Writer writer = HFile.getWriterFactoryNoCache(conf).withOutputStream(fout).withFileContext(context).withComparator(KeyValue.COMPARATOR).create();
        writer.append(TestSeekTo.toKV("c", tagUsage));
        writer.append(TestSeekTo.toKV("e", tagUsage));
        writer.append(TestSeekTo.toKV("g", tagUsage));
        writer.append(TestSeekTo.toKV("i", tagUsage));
        writer.append(TestSeekTo.toKV("k", tagUsage));
        writer.close();
        fout.close();
        return ncTFile;
    }

    @Test
    public void testSeekBefore() throws Exception {
        this.testSeekBeforeInternals(TagUsage.NO_TAG);
        this.testSeekBeforeInternals(TagUsage.ONLY_TAG);
        this.testSeekBeforeInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekBeforeInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader(fs, p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        Assert.assertEquals((Object)false, (Object)scanner.seekBefore(TestSeekTo.toKV("a", tagUsage)));
        Assert.assertEquals((Object)false, (Object)scanner.seekBefore(TestSeekTo.toKV("c", tagUsage)));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("f", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("h", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("j", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Cell cell = scanner.getKeyValue();
        if (tagUsage != TagUsage.NO_TAG && cell.getTagsLength() > 0) {
            Iterator<Tag> tagsIterator = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            while (tagsIterator.hasNext()) {
                Tag next = tagsIterator.next();
                Assert.assertEquals((Object)"myTag1", (Object)Bytes.toString(next.getValue()));
            }
        }
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("l", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        reader.close();
        this.deleteTestDir(fs);
    }

    @Test
    public void testSeekBeforeWithReSeekTo() throws Exception {
        this.testSeekBeforeWithReSeekToInternals(TagUsage.NO_TAG);
        this.testSeekBeforeWithReSeekToInternals(TagUsage.ONLY_TAG);
        this.testSeekBeforeWithReSeekToInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekBeforeWithReSeekToInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader(fs, p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        Assert.assertEquals((Object)false, (Object)scanner.seekBefore(TestSeekTo.toKV("a", tagUsage)));
        Assert.assertEquals((Object)false, (Object)scanner.seekBefore(TestSeekTo.toKV("b", tagUsage)));
        Assert.assertEquals((Object)false, (Object)scanner.seekBefore(TestSeekTo.toKV("c", tagUsage)));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("c", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("f", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((Object)"e", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("h", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((Object)"g", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("j", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertTrue((boolean)scanner.seekBefore(TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((Object)true, (Object)scanner.seekBefore(TestSeekTo.toKV("l", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.reseekTo(TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        this.deleteTestDir(fs);
    }

    @Test
    public void testSeekTo() throws Exception {
        this.testSeekToInternals(TagUsage.NO_TAG);
        this.testSeekToInternals(TagUsage.ONLY_TAG);
        this.testSeekToInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekToInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader(fs, p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        Assert.assertEquals((long)2L, (long)reader.getDataBlockIndexReader().getRootBlockCount());
        HFileScanner scanner = reader.getScanner(false, true);
        Assert.assertEquals((long)-1L, (long)scanner.seekTo(TestSeekTo.toKV("a", tagUsage)));
        Assert.assertEquals((long)1L, (long)scanner.seekTo(TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((Object)"c", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)0L, (long)scanner.seekTo(TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((Object)"i", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        Assert.assertEquals((long)1L, (long)scanner.seekTo(TestSeekTo.toKV("l", tagUsage)));
        if (this.encoding == DataBlockEncoding.PREFIX_TREE) {
            Assert.assertEquals(null, (Object)scanner.getKeyValue());
        } else {
            Assert.assertEquals((Object)"k", (Object)TestSeekTo.toRowStr(scanner.getKeyValue()));
        }
        reader.close();
        this.deleteTestDir(fs);
    }

    @Test
    public void testBlockContainingKey() throws Exception {
        this.testBlockContainingKeyInternals(TagUsage.NO_TAG);
        this.testBlockContainingKeyInternals(TagUsage.ONLY_TAG);
        this.testBlockContainingKeyInternals(TagUsage.PARTIAL_TAG);
    }

    protected void deleteTestDir(FileSystem fs) throws IOException {
        Path dataTestDir = TEST_UTIL.getDataTestDir();
        if (fs.exists(dataTestDir)) {
            fs.delete(dataTestDir, true);
        }
    }

    protected void testBlockContainingKeyInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Reader reader = HFile.createReader(fs, p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        HFileBlockIndex.BlockIndexReader blockIndexReader = reader.getDataBlockIndexReader();
        System.out.println(blockIndexReader.toString());
        Assert.assertEquals((long)-1L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("a", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("c", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("d", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("e", tagUsage)));
        Assert.assertEquals((long)0L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("g", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("h", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("i", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("j", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("k", tagUsage)));
        Assert.assertEquals((long)1L, (long)blockIndexReader.rootBlockContainingKey(TestSeekTo.toKV("l", tagUsage)));
        reader.close();
        this.deleteTestDir(fs);
    }
}

