/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.io.MetricsIO;
import org.apache.hadoop.hbase.io.MetricsIOWrapper;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricsIO {
    public MetricsAssertHelper HELPER = CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testMetrics() {
        MetricsIO metrics = new MetricsIO(new MetricsIOWrapper(){

            @Override
            public long getChecksumFailures() {
                return 40L;
            }
        });
        metrics.updateFsReadTime(100L);
        metrics.updateFsReadTime(200L);
        metrics.updateFsPreadTime(300L);
        metrics.updateFsWriteTime(400L);
        metrics.updateFsWriteTime(500L);
        metrics.updateFsWriteTime(600L);
        this.HELPER.assertCounter("fsChecksumFailureCount", 40L, metrics.getMetricsSource());
        this.HELPER.assertCounter("fsReadTime_numOps", 2L, metrics.getMetricsSource());
        this.HELPER.assertCounter("fsPReadTime_numOps", 1L, metrics.getMetricsSource());
        this.HELPER.assertCounter("fsWriteTime_numOps", 3L, metrics.getMetricsSource());
    }
}

