/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.io.MetricsIOSource;
import org.apache.hadoop.hbase.io.MetricsIOWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;

public class MetricsIO {
    private final MetricsIOSource source;
    private final MetricsIOWrapper wrapper;

    public MetricsIO(MetricsIOWrapper wrapper) {
        this(CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createIO(wrapper), wrapper);
    }

    MetricsIO(MetricsIOSource source, MetricsIOWrapper wrapper) {
        this.source = source;
        this.wrapper = wrapper;
    }

    @VisibleForTesting
    public MetricsIOSource getMetricsSource() {
        return this.source;
    }

    @VisibleForTesting
    public MetricsIOWrapper getWrapper() {
        return this.wrapper;
    }

    public void updateFsReadTime(long t) {
        this.source.updateFsReadTime(t);
    }

    public void updateFsPreadTime(long t) {
        this.source.updateFsPReadTime(t);
    }

    public void updateFsWriteTime(long t) {
        this.source.updateFsWriteTime(t);
    }
}

