/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFilterFromRegionSide {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static HRegion REGION;
    private static TableName TABLE_NAME;
    private static int NUM_ROWS;
    private static byte[] ROW;
    private static byte[][] ROWS;
    private static int NUM_FAMILIES;
    private static byte[] FAMILY;
    private static byte[][] FAMILIES;
    private static int NUM_QUALIFIERS;
    private static byte[] QUALIFIER;
    private static byte[][] QUALIFIERS;
    private static int VALUE_SIZE;
    private static byte[] VALUE;
    private static int NUM_COLS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        for (byte[] family : FAMILIES) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        REGION = HBaseTestingUtility.createRegionAndWAL(info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), htd);
        for (Put put : TestFilterFromRegionSide.createPuts(ROWS, FAMILIES, QUALIFIERS, VALUE)) {
            REGION.put(put);
        }
    }

    private static ArrayList<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] row1 : rows) {
            Put put = new Put(row1);
            for (byte[] family : families) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(row1, family, qualifiers[qual], (long)qual, value);
                    put.add(kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REGION.close();
    }

    @Test
    public void testFirstKeyOnlyFilterAndBatch() throws IOException {
        Scan scan = new Scan();
        scan.setFilter(new FirstKeyOnlyFilter());
        scan.setBatch(1);
        RegionScanner scanner = REGION.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        for (int i = 0; i < NUM_ROWS; ++i) {
            results.clear();
            scanner.next(results);
            Assert.assertEquals((long)1L, (long)results.size());
            Cell cell = (Cell)results.get(0);
            Assert.assertArrayEquals((byte[])ROWS[i], (byte[])Bytes.copy(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
        }
        Assert.assertFalse((boolean)scanner.next(results));
        scanner.close();
    }

    @Test
    public void testFirstSeveralCellsFilterAndBatch() throws IOException {
        Scan scan = new Scan();
        scan.setFilter(new FirstSeveralCellsFilter());
        scan.setBatch(NUM_COLS);
        RegionScanner scanner = REGION.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        for (int i = 0; i < NUM_ROWS; ++i) {
            results.clear();
            scanner.next(results);
            Assert.assertEquals((long)NUM_COLS, (long)results.size());
            Cell cell = (Cell)results.get(0);
            Assert.assertArrayEquals((byte[])ROWS[i], (byte[])Bytes.copy(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
            Assert.assertArrayEquals((byte[])FAMILIES[0], (byte[])Bytes.copy(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
            Assert.assertArrayEquals((byte[])QUALIFIERS[0], (byte[])Bytes.copy(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
        }
        Assert.assertFalse((boolean)scanner.next(results));
        scanner.close();
    }

    static {
        TABLE_NAME = TableName.valueOf("TestFilterFromRegionSide");
        NUM_ROWS = 5;
        ROW = Bytes.toBytes("testRow");
        ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
        NUM_FAMILIES = 5;
        FAMILY = Bytes.toBytes("testFamily");
        FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
        NUM_QUALIFIERS = 5;
        QUALIFIER = Bytes.toBytes("testQualifier");
        QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
        VALUE_SIZE = 1024;
        VALUE = Bytes.createMaxByteArray(VALUE_SIZE);
        NUM_COLS = NUM_FAMILIES * NUM_QUALIFIERS;
    }

    public static class FirstSeveralCellsFilter
    extends FilterBase {
        private int count = 0;

        @Override
        public void reset() {
            this.count = 0;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) {
            if (this.count++ < NUM_COLS) {
                return Filter.ReturnCode.INCLUDE;
            }
            return Filter.ReturnCode.SKIP;
        }

        public static Filter parseFrom(byte[] pbBytes) {
            return new FirstSeveralCellsFilter();
        }
    }
}

