/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHTableWrapper {
    private static final HBaseTestingUtility util = new HBaseTestingUtility();
    private static final TableName TEST_TABLE = TableName.valueOf("test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes("f1");
    private static final byte[] ROW_A = Bytes.toBytes("aaa");
    private static final byte[] ROW_B = Bytes.toBytes("bbb");
    private static final byte[] ROW_C = Bytes.toBytes("ccc");
    private static final byte[] ROW_D = Bytes.toBytes("ddd");
    private static final byte[] ROW_E = Bytes.toBytes("eee");
    private static final byte[] qualifierCol1 = Bytes.toBytes("col1");
    private static final byte[] bytes1 = Bytes.toBytes(1);
    private static final byte[] bytes2 = Bytes.toBytes(2);
    private static final byte[] bytes3 = Bytes.toBytes(3);
    private static final byte[] bytes4 = Bytes.toBytes(4);
    private static final byte[] bytes5 = Bytes.toBytes(5);
    private HTableInterface hTableInterface;
    private Table table;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        this.table = util.createTable(TEST_TABLE, TEST_FAMILY);
        Put puta = new Put(ROW_A);
        puta.add(TEST_FAMILY, qualifierCol1, bytes1);
        this.table.put(puta);
        Put putb = new Put(ROW_B);
        putb.add(TEST_FAMILY, qualifierCol1, bytes2);
        this.table.put(putb);
        Put putc = new Put(ROW_C);
        putc.add(TEST_FAMILY, qualifierCol1, bytes3);
        this.table.put(putc);
    }

    @After
    public void after() throws Exception {
        try {
            if (this.table != null) {
                this.table.close();
            }
        }
        finally {
            util.deleteTable(TEST_TABLE);
        }
    }

    @Test
    public void testHTableInterfaceMethods() throws Exception {
        Configuration conf = util.getConfiguration();
        MasterCoprocessorHost cpHost = util.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        Class<DummyRegionObserver> implClazz = DummyRegionObserver.class;
        cpHost.load(implClazz, 0, conf);
        CoprocessorEnvironment env = cpHost.findCoprocessorEnvironment(implClazz.getName());
        Assert.assertEquals((long)1L, (long)env.getVersion());
        Assert.assertEquals((Object)VersionInfo.getVersion(), (Object)env.getHBaseVersion());
        this.hTableInterface = env.getTable(TEST_TABLE);
        this.checkHTableInterfaceMethods();
        cpHost.shutdown(env);
    }

    private void checkHTableInterfaceMethods() throws Exception {
        this.checkConf();
        this.checkNameAndDescriptor();
        this.checkAutoFlush();
        this.checkBufferSize();
        this.checkExists();
        this.checkGetRowOrBefore();
        this.checkAppend();
        this.checkPutsAndDeletes();
        this.checkCheckAndPut();
        this.checkCheckAndDelete();
        this.checkIncrementColumnValue();
        this.checkIncrement();
        this.checkBatch();
        this.checkCoprocessorService();
        this.checkMutateRow();
        this.checkResultScanner();
        this.hTableInterface.flushCommits();
        this.hTableInterface.close();
    }

    private void checkConf() {
        Configuration confActual;
        Configuration confExpected = util.getConfiguration();
        Assert.assertTrue((confExpected == (confActual = this.hTableInterface.getConfiguration()) ? 1 : 0) != 0);
    }

    private void checkNameAndDescriptor() throws IOException {
        Assert.assertEquals((Object)TEST_TABLE, (Object)this.hTableInterface.getName());
        Assert.assertEquals((Object)this.table.getTableDescriptor(), (Object)this.hTableInterface.getTableDescriptor());
    }

    private void checkAutoFlush() {
        boolean initialAutoFlush = this.hTableInterface.isAutoFlush();
        this.hTableInterface.setAutoFlush(false);
        Assert.assertFalse((boolean)this.hTableInterface.isAutoFlush());
        this.hTableInterface.setAutoFlush(true);
        Assert.assertTrue((boolean)this.hTableInterface.isAutoFlush());
        this.hTableInterface.setAutoFlush(initialAutoFlush);
    }

    private void checkBufferSize() throws IOException {
        long initialWriteBufferSize = this.hTableInterface.getWriteBufferSize();
        this.hTableInterface.setWriteBufferSize(12345L);
        Assert.assertEquals((long)12345L, (long)this.hTableInterface.getWriteBufferSize());
        this.hTableInterface.setWriteBufferSize(initialWriteBufferSize);
    }

    private void checkExists() throws IOException {
        boolean ex = this.hTableInterface.exists(new Get(ROW_A).addColumn(TEST_FAMILY, qualifierCol1));
        Assert.assertTrue((boolean)ex);
        Object[] exArray = this.hTableInterface.exists(Arrays.asList(new Get(ROW_A).addColumn(TEST_FAMILY, qualifierCol1), new Get(ROW_B).addColumn(TEST_FAMILY, qualifierCol1), new Get(ROW_C).addColumn(TEST_FAMILY, qualifierCol1), new Get(Bytes.toBytes("does not exist")).addColumn(TEST_FAMILY, qualifierCol1)));
        Assert.assertArrayEquals((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}, (Object[])exArray);
    }

    private void checkGetRowOrBefore() throws IOException {
        Result rowOrBeforeResult = this.hTableInterface.getRowOrBefore(ROW_A, TEST_FAMILY);
        Assert.assertArrayEquals((byte[])ROW_A, (byte[])rowOrBeforeResult.getRow());
    }

    private void checkAppend() throws IOException {
        byte[] appendValue = Bytes.toBytes("append");
        Append append = new Append(qualifierCol1).add(TEST_FAMILY, qualifierCol1, appendValue);
        Result appendResult = this.hTableInterface.append(append);
        byte[] appendedRow = appendResult.getRow();
        this.checkRowValue(appendedRow, appendValue);
    }

    private void checkPutsAndDeletes() throws IOException {
        Put putD = new Put(ROW_D).add(TEST_FAMILY, qualifierCol1, bytes2);
        this.hTableInterface.put(putD);
        this.checkRowValue(ROW_D, bytes2);
        Delete delete = new Delete(ROW_D);
        this.hTableInterface.delete(delete);
        this.checkRowValue(ROW_D, null);
        Put[] puts = new Put[]{new Put(ROW_D).add(TEST_FAMILY, qualifierCol1, bytes2), new Put(ROW_E).add(TEST_FAMILY, qualifierCol1, bytes3)};
        this.hTableInterface.put(Arrays.asList(puts));
        this.checkRowsValues(new byte[][]{ROW_D, ROW_E}, new byte[][]{bytes2, bytes3});
        Delete[] deletes = new Delete[]{new Delete(ROW_D), new Delete(ROW_E)};
        this.hTableInterface.delete(new ArrayList<Delete>(Arrays.asList(deletes)));
        this.checkRowsValues(new byte[][]{ROW_D, ROW_E}, new byte[][]{null, null});
    }

    private void checkCheckAndPut() throws IOException {
        Put putC = new Put(ROW_C).add(TEST_FAMILY, qualifierCol1, bytes5);
        Assert.assertFalse((boolean)this.hTableInterface.checkAndPut(ROW_C, TEST_FAMILY, qualifierCol1, bytes4, putC));
        Assert.assertTrue((boolean)this.hTableInterface.checkAndPut(ROW_C, TEST_FAMILY, qualifierCol1, bytes3, putC));
        this.checkRowValue(ROW_C, bytes5);
    }

    private void checkCheckAndDelete() throws IOException {
        Delete delete = new Delete(ROW_C);
        Assert.assertFalse((boolean)this.hTableInterface.checkAndDelete(ROW_C, TEST_FAMILY, qualifierCol1, bytes4, delete));
        Assert.assertTrue((boolean)this.hTableInterface.checkAndDelete(ROW_C, TEST_FAMILY, qualifierCol1, bytes5, delete));
        this.checkRowValue(ROW_C, null);
    }

    private void checkIncrementColumnValue() throws IOException {
        this.hTableInterface.put(new Put(ROW_A).add(TEST_FAMILY, qualifierCol1, Bytes.toBytes(1L)));
        this.checkRowValue(ROW_A, Bytes.toBytes(1L));
        long newVal = this.hTableInterface.incrementColumnValue(ROW_A, TEST_FAMILY, qualifierCol1, 10L);
        Assert.assertEquals((long)11L, (long)newVal);
        this.checkRowValue(ROW_A, Bytes.toBytes(11L));
        long newVal2 = this.hTableInterface.incrementColumnValue(ROW_A, TEST_FAMILY, qualifierCol1, -10L, Durability.SYNC_WAL);
        Assert.assertEquals((long)1L, (long)newVal2);
        this.checkRowValue(ROW_A, Bytes.toBytes(1L));
    }

    private void checkIncrement() throws IOException {
        this.hTableInterface.increment(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, -5L));
        this.checkRowValue(ROW_A, Bytes.toBytes(-4L));
    }

    private void checkBatch() throws IOException, InterruptedException {
        Object[] results1 = this.hTableInterface.batch(Arrays.asList(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L), new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L)));
        Assert.assertEquals((long)2L, (long)results1.length);
        for (Object r2 : results1) {
            Assert.assertTrue((boolean)(r2 instanceof Result));
        }
        this.checkRowValue(ROW_A, Bytes.toBytes(0L));
        Object[] results2 = new Result[2];
        this.hTableInterface.batch(Arrays.asList(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L), new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L)), results2);
        for (Object r2 : results2) {
            Assert.assertTrue((boolean)(r2 instanceof Result));
        }
        this.checkRowValue(ROW_A, Bytes.toBytes(4L));
        final long[] updateCounter = new long[]{0L};
        Object[] results3 = this.hTableInterface.batchCallback(Arrays.asList(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L), new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L)), new Batch.Callback<Result>(){

            @Override
            public void update(byte[] region, byte[] row, Result result) {
                updateCounter[0] = updateCounter[0] + 1L;
            }
        });
        Assert.assertEquals((long)2L, (long)updateCounter[0]);
        Assert.assertEquals((long)2L, (long)results3.length);
        for (Object r3 : results3) {
            Assert.assertTrue((boolean)(r3 instanceof Result));
        }
        this.checkRowValue(ROW_A, Bytes.toBytes(8L));
        Object[] results4 = new Result[2];
        updateCounter[0] = 0L;
        this.hTableInterface.batchCallback(Arrays.asList(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L), new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L)), results4, new Batch.Callback<Result>(){

            @Override
            public void update(byte[] region, byte[] row, Result result) {
                updateCounter[0] = updateCounter[0] + 1L;
            }
        });
        Assert.assertEquals((long)2L, (long)updateCounter[0]);
        for (Object r2 : results4) {
            Assert.assertTrue((boolean)(r2 instanceof Result));
        }
        this.checkRowValue(ROW_A, Bytes.toBytes(12L));
    }

    private void checkCoprocessorService() {
        CoprocessorRpcChannel crc = this.hTableInterface.coprocessorService(ROW_A);
        Assert.assertNotNull((Object)crc);
    }

    private void checkMutateRow() throws IOException {
        Put put = new Put(ROW_A).add(TEST_FAMILY, qualifierCol1, bytes1);
        RowMutations rowMutations = new RowMutations(ROW_A);
        rowMutations.add(put);
        this.hTableInterface.mutateRow(rowMutations);
        this.checkRowValue(ROW_A, bytes1);
    }

    private void checkResultScanner() throws IOException {
        ResultScanner resultScanner = this.hTableInterface.getScanner(TEST_FAMILY);
        Result[] results = resultScanner.next(10);
        Assert.assertEquals((long)3L, (long)results.length);
        resultScanner = this.hTableInterface.getScanner(TEST_FAMILY, qualifierCol1);
        results = resultScanner.next(10);
        Assert.assertEquals((long)3L, (long)results.length);
        resultScanner = this.hTableInterface.getScanner(new Scan(ROW_A, ROW_C));
        results = resultScanner.next(10);
        Assert.assertEquals((long)2L, (long)results.length);
    }

    private void checkRowValue(byte[] row, byte[] expectedValue) throws IOException {
        Get get = new Get(row).addColumn(TEST_FAMILY, qualifierCol1);
        Result result = this.hTableInterface.get(get);
        byte[] actualValue = result.getValue(TEST_FAMILY, qualifierCol1);
        Assert.assertArrayEquals((byte[])expectedValue, (byte[])actualValue);
    }

    private void checkRowsValues(byte[][] rows, byte[][] expectedValues) throws IOException {
        if (rows.length != expectedValues.length) {
            throw new IllegalArgumentException();
        }
        Get[] gets = new Get[rows.length];
        for (int i = 0; i < gets.length; ++i) {
            gets[i] = new Get(rows[i]).addColumn(TEST_FAMILY, qualifierCol1);
        }
        Result[] results = this.hTableInterface.get(Arrays.asList(gets));
        for (int i = 0; i < expectedValues.length; ++i) {
            byte[] actualValue = results[i].getValue(TEST_FAMILY, qualifierCol1);
            Assert.assertArrayEquals((byte[])expectedValues[i], (byte[])actualValue);
        }
    }

    static class DummyRegionObserver
    extends BaseRegionObserver {
        DummyRegionObserver() {
        }
    }
}

