/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAggregateProtocol {
    protected static Log myLog = LogFactory.getLog(TestAggregateProtocol.class);
    private static final TableName TEST_TABLE = TableName.valueOf("TestTable");
    private static final byte[] TEST_FAMILY = Bytes.toBytes("TestFamily");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes("TestQualifier");
    private static final byte[] TEST_MULTI_CQ = Bytes.toBytes("TestMultiCQ");
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static final int ROWSIZE = 20;
    private static final int rowSeperator1 = 5;
    private static final int rowSeperator2 = 12;
    private static byte[][] ROWS = TestAggregateProtocol.makeN(ROW, 20);
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static Configuration conf = util.getConfiguration();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.set("hbase.coprocessor.region.classes", "org.apache.hadoop.hbase.coprocessor.AggregateImplementation");
        util.startMiniCluster(2);
        byte[][] SPLIT_KEYS = new byte[][]{ROWS[5], ROWS[12]};
        HTable table = util.createTable(TEST_TABLE, TEST_FAMILY, (byte[][])SPLIT_KEYS);
        for (int i = 0; i < 20; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            Long l = new Long(i);
            put.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes(l));
            table.put(put);
            Put p2 = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            p2.add(TEST_FAMILY, Bytes.add(TEST_MULTI_CQ, Bytes.toBytes(l)), Bytes.toBytes(l * 10L));
            table.put(p2);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add(base, Bytes.toBytes(i));
        }
        return ret;
    }

    @Test(timeout=300000L)
    public void testMedianWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long median = aClient.median(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)8L, (long)median);
    }

    @Test(timeout=300000L)
    public void testRowCountWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[2]);
        scan.setStopRow(ROWS[14]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long rowCount = aClient.rowCount(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)12L, (long)rowCount);
    }

    @Test(timeout=300000L)
    public void testRowCountAllTable() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long rowCount = aClient.rowCount(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)20L, (long)rowCount);
    }

    @Test(timeout=300000L)
    public void testRowCountWithInvalidRange1() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[2]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long rowCount = -1L;
        try {
            rowCount = aClient.rowCount(TEST_TABLE, ci, scan);
        }
        catch (Throwable e) {
            myLog.error((Object)"Exception thrown in the invalidRange method", e);
        }
        Assert.assertEquals((long)-1L, (long)rowCount);
    }

    @Test(timeout=300000L)
    public void testRowCountWithInvalidRange2() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[5]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long rowCount = -1L;
        try {
            rowCount = aClient.rowCount(TEST_TABLE, ci, scan);
        }
        catch (Throwable e) {
            rowCount = 0L;
        }
        Assert.assertEquals((long)0L, (long)rowCount);
    }

    @Test(timeout=300000L)
    public void testRowCountWithNullCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long rowCount = aClient.rowCount(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)20L, (long)rowCount);
    }

    @Test(timeout=300000L)
    public void testRowCountWithPrefixFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        PrefixFilter f = new PrefixFilter(Bytes.toBytes("foo:bar"));
        scan.setFilter(f);
        long rowCount = aClient.rowCount(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)0L, (long)rowCount);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long maximum = aClient.max(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)19L, (long)maximum);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long max = aClient.max(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)14L, (long)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long maximum = aClient.max(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)190L, (long)maximum);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long max = aClient.max(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)60L, (long)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Scan scan = new Scan();
        Long max = null;
        try {
            max = aClient.max(TEST_TABLE, ci, scan);
        }
        catch (Throwable e) {
            max = null;
        }
        Assert.assertEquals(null, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Scan scan = new Scan();
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[2]);
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        long max = Long.MIN_VALUE;
        try {
            max = aClient.max(TEST_TABLE, ci, scan);
        }
        catch (Throwable e) {
            max = 0L;
        }
        Assert.assertEquals((long)0L, (long)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithInvalidRange2() throws Throwable {
        long max = Long.MIN_VALUE;
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[4]);
        try {
            AggregationClient aClient = new AggregationClient(conf);
            LongColumnInterpreter ci = new LongColumnInterpreter();
            max = aClient.max(TEST_TABLE, ci, scan);
        }
        catch (Exception e) {
            max = 0L;
        }
        Assert.assertEquals((long)0L, (long)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithFilter() throws Throwable {
        Long max = 0L;
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes("foo:bar"));
        scan.setFilter(f);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        max = aClient.max(TEST_TABLE, ci, scan);
        Assert.assertEquals(null, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(HConstants.EMPTY_START_ROW);
        scan.setStopRow(HConstants.EMPTY_END_ROW);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long min = aClient.min(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)0L, (long)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long min = aClient.min(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)5L, (long)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(HConstants.EMPTY_START_ROW);
        scan.setStopRow(HConstants.EMPTY_END_ROW);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long min = aClient.min(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)0L, (long)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long min = aClient.min(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)6L, (long)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long min = null;
        try {
            min = aClient.min(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Long min = null;
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[2]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        try {
            min = aClient.min(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithInvalidRange2() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[6]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long min = null;
        try {
            min = aClient.min(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes("foo:bar"));
        scan.setFilter(f);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long min = null;
        min = aClient.min(TEST_TABLE, ci, scan);
        Assert.assertEquals(null, (Object)min);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long sum = aClient.sum(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)190L, (long)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long sum = aClient.sum(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)95L, (long)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long sum = aClient.sum(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)2090L, (long)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        long sum = aClient.sum(TEST_TABLE, ci, scan);
        Assert.assertEquals((long)66L, (long)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long sum = null;
        try {
            sum = aClient.sum(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, sum);
    }

    @Test(timeout=300000L)
    public void testSumWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[2]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long sum = null;
        try {
            sum = aClient.sum(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, sum);
    }

    @Test(timeout=300000L)
    public void testSumWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes("foo:bar"));
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setFilter(f);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Long sum = null;
        sum = aClient.sum(TEST_TABLE, ci, scan);
        Assert.assertEquals(null, (Object)sum);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)9.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)9.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)104.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)66.0, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Double avg = null;
        try {
            avg = aClient.avg(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, avg);
    }

    @Test(timeout=300000L)
    public void testAvgWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[1]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Double avg = null;
        try {
            avg = aClient.avg(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, avg);
    }

    @Test(timeout=300000L)
    public void testAvgWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes("foo:bar"));
        scan.setFilter(f);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Double avg = null;
        avg = aClient.avg(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)Double.NaN, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double std = aClient.std(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)5.766, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double std = aClient.std(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)2.87, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double std = aClient.std(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)63.42, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        double std = aClient.std(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)0.0, (double)std, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[17]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Double std = null;
        try {
            std = aClient.std(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, std);
    }

    @Test(timeout=300000L)
    public void testStdWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[1]);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Double std = null;
        try {
            std = aClient.std(TEST_TABLE, ci, scan);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals(null, std);
    }

    @Test(timeout=300000L)
    public void testStdWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes("foo:bar"));
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setFilter(f);
        LongColumnInterpreter ci = new LongColumnInterpreter();
        Double std = null;
        std = aClient.std(TEST_TABLE, ci, scan);
        Assert.assertEquals((double)Double.NaN, (double)std, (double)0.0);
    }
}

