/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestLeaseRenewal {
    public MetricsAssertHelper HELPER = CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static final byte[] ANOTHERROW = Bytes.toBytes("anotherrow");
    private static final byte[] COL_QUAL = Bytes.toBytes("f1");
    private static final byte[] VAL_BYTES = Bytes.toBytes("v1");
    private static final byte[] ROW_BYTES = Bytes.toBytes("r1");
    private static final int leaseTimeout = 15000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", 15000);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : TEST_UTIL.getHBaseAdmin().listTables()) {
            this.LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testLeaseRenewal() throws Exception {
        HTable table = TEST_UTIL.createTable(TableName.valueOf("testLeaseRenewal"), FAMILY);
        Put p = new Put(ROW_BYTES);
        p.addColumn(FAMILY, COL_QUAL, VAL_BYTES);
        table.put(p);
        p = new Put(ANOTHERROW);
        p.addColumn(FAMILY, COL_QUAL, VAL_BYTES);
        table.put(p);
        Scan s = new Scan();
        s.setCaching(1);
        ResultScanner rs = table.getScanner(s);
        Assert.assertFalse((boolean)((AbstractClientScanner)rs).renewLease());
        Assert.assertTrue((boolean)Arrays.equals(rs.next().getRow(), ANOTHERROW));
        Thread.sleep(7500L);
        Assert.assertTrue((boolean)((AbstractClientScanner)rs).renewLease());
        Thread.sleep(7500L);
        Assert.assertTrue((boolean)((AbstractClientScanner)rs).renewLease());
        Thread.sleep(7500L);
        Assert.assertTrue((boolean)((AbstractClientScanner)rs).renewLease());
        Assert.assertTrue((boolean)Arrays.equals(rs.next().getRow(), ROW_BYTES));
        Assert.assertFalse((boolean)((AbstractClientScanner)rs).renewLease());
        Assert.assertNull((Object)rs.next());
        Assert.assertFalse((boolean)((AbstractClientScanner)rs).renewLease());
        rs.close();
        table.close();
        MetricsHBaseServerSource serverSource = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRpcServer().getMetrics().getMetricsSource();
        this.HELPER.assertCounter("exceptions.OutOfOrderScannerNextException", 0L, serverSource);
    }
}

