/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestClientTimeouts {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static int SLAVES = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", RandomTimeoutRpcClient.class.getName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminTimeout() throws Exception {
        boolean lastFailed = false;
        int initialInvocations = RandomTimeoutBlockingRpcChannel.invokations.get();
        try (RandomTimeoutRpcClient rpcClient = (RandomTimeoutRpcClient)RpcClientFactory.createClient(TEST_UTIL.getConfiguration(), TEST_UTIL.getClusterKey());){
            for (int i = 0; i < 5 || lastFailed && i < 100; ++i) {
                lastFailed = false;
                Configuration conf = HBaseConfiguration.create(TEST_UTIL.getConfiguration());
                conf.set("hbase.client.instance.id", String.valueOf(-1));
                Admin admin = null;
                Connection connection = null;
                try {
                    connection = ConnectionFactory.createConnection(conf);
                    admin = connection.getAdmin();
                    HBaseAdmin.checkHBaseAvailable(conf);
                    admin.setBalancerRunning(false, false);
                    continue;
                }
                catch (MasterNotRunningException ex) {
                    lastFailed = true;
                    continue;
                }
                finally {
                    if (admin != null) {
                        admin.close();
                        if (admin.getConnection().isClosed()) {
                            rpcClient = (RandomTimeoutRpcClient)RpcClientFactory.createClient(TEST_UTIL.getConfiguration(), TEST_UTIL.getClusterKey());
                        }
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            Assert.assertFalse((boolean)lastFailed);
            Assert.assertTrue((RandomTimeoutBlockingRpcChannel.invokations.get() > initialInvocations ? 1 : 0) != 0);
        }
    }

    static class RandomTimeoutBlockingRpcChannel
    extends AbstractRpcClient.BlockingRpcChannelImplementation {
        private static final Random RANDOM = new Random(System.currentTimeMillis());
        public static final double CHANCE_OF_TIMEOUT = 0.3;
        private static AtomicInteger invokations = new AtomicInteger();

        RandomTimeoutBlockingRpcChannel(BlockingRpcClient rpcClient, ServerName sn, User ticket, int rpcTimeout) {
            super(rpcClient, new InetSocketAddress(sn.getHostname(), sn.getPort()), ticket, rpcTimeout);
        }

        @Override
        public Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType) throws ServiceException {
            invokations.getAndIncrement();
            if ((double)RANDOM.nextFloat() < 0.3) {
                throw new ServiceException((Throwable)new SocketTimeoutException("fake timeout"));
            }
            return super.callBlockingMethod(md, controller, param, returnType);
        }
    }

    public static class RandomTimeoutRpcClient
    extends BlockingRpcClient {
        public RandomTimeoutRpcClient(Configuration conf, String clusterId, SocketAddress localAddr, MetricsConnection metrics) {
            super(conf, clusterId, localAddr, metrics);
        }

        @Override
        public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User ticket, int rpcTimeout) throws UnknownHostException {
            return new RandomTimeoutBlockingRpcChannel(this, sn, ticket, rpcTimeout);
        }
    }
}

