/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class MockRegionServerServicesWithWALs
implements RegionServerServices {
    WALProvider provider;
    RegionServerServices rss;

    public MockRegionServerServicesWithWALs(RegionServerServices rss, WALProvider provider) {
        this.rss = rss;
        this.provider = provider;
    }

    @Override
    public boolean isStopping() {
        return this.rss.isStopping();
    }

    @Override
    public WAL getWAL(HRegionInfo hri) throws IOException {
        return this.provider.getWAL(hri.getEncodedNameAsBytes(), hri.getTable().getNamespace());
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return this.rss.getCompactionRequester();
    }

    @Override
    public FlushRequester getFlushRequester() {
        return this.rss.getFlushRequester();
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return this.rss.getRegionServerAccounting();
    }

    @Override
    public TableLockManager getTableLockManager() {
        return this.rss.getTableLockManager();
    }

    @Override
    public RegionServerQuotaManager getRegionServerQuotaManager() {
        return this.rss.getRegionServerQuotaManager();
    }

    @Override
    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws KeeperException, IOException {
        this.rss.postOpenDeployTasks(context);
    }

    @Override
    public void postOpenDeployTasks(Region r) throws KeeperException, IOException {
        this.rss.postOpenDeployTasks(r);
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return this.rss.reportRegionStateTransition(context);
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
        return this.rss.reportRegionStateTransition(code, openSeqNum, hris);
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo ... hris) {
        return this.rss.reportRegionStateTransition(code, hris);
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return this.rss.getRpcServer();
    }

    @Override
    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.rss.getRegionsInTransitionInRS();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.rss.getFileSystem();
    }

    @Override
    public Leases getLeases() {
        return this.rss.getLeases();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.rss.getExecutorService();
    }

    @Override
    public Map<String, Region> getRecoveringRegions() {
        return this.rss.getRecoveringRegions();
    }

    @Override
    public ServerNonceManager getNonceManager() {
        return this.rss.getNonceManager();
    }

    @Override
    public boolean registerService(Service service) {
        return this.rss.registerService(service);
    }

    @Override
    public HeapMemoryManager getHeapMemoryManager() {
        return this.rss.getHeapMemoryManager();
    }

    @Override
    public double getCompactionPressure() {
        return this.rss.getCompactionPressure();
    }

    @Override
    public Set<TableName> getOnlineTables() {
        return this.rss.getOnlineTables();
    }

    @Override
    public ThroughputController getFlushThroughputController() {
        return this.rss.getFlushThroughputController();
    }

    @Override
    public double getFlushPressure() {
        return this.rss.getFlushPressure();
    }

    @Override
    public MetricsRegionServer getMetrics() {
        return this.rss.getMetrics();
    }

    @Override
    public void unassign(byte[] regionName) throws IOException {
        this.rss.unassign(regionName);
    }

    @Override
    public void addToOnlineRegions(Region r) {
        this.rss.addToOnlineRegions(r);
    }

    @Override
    public boolean removeFromOnlineRegions(Region r, ServerName destination) {
        return this.rss.removeFromOnlineRegions(r, destination);
    }

    @Override
    public Region getFromOnlineRegions(String encodedRegionName) {
        return this.rss.getFromOnlineRegions(encodedRegionName);
    }

    @Override
    public List<Region> getOnlineRegions(TableName tableName) throws IOException {
        return this.rss.getOnlineRegions(tableName);
    }

    @Override
    public List<Region> getOnlineRegions() {
        return this.rss.getOnlineRegions();
    }

    @Override
    public Configuration getConfiguration() {
        return this.rss.getConfiguration();
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.rss.getZooKeeper();
    }

    @Override
    public ClusterConnection getConnection() {
        return this.rss.getConnection();
    }

    @Override
    public MetaTableLocator getMetaTableLocator() {
        return this.rss.getMetaTableLocator();
    }

    @Override
    public ServerName getServerName() {
        return this.rss.getServerName();
    }

    @Override
    public CoordinatedStateManager getCoordinatedStateManager() {
        return this.rss.getCoordinatedStateManager();
    }

    @Override
    public ChoreService getChoreService() {
        return this.rss.getChoreService();
    }

    @Override
    public void abort(String why, Throwable e) {
        this.rss.abort(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.rss.isAborted();
    }

    @Override
    public void stop(String why) {
        this.rss.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.rss.isStopped();
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
        this.rss.updateRegionFavoredNodesMapping(encodedRegionName, favoredNodes);
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return this.rss.getFavoredNodesForRegion(encodedRegionName);
    }
}

