/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.security.maprsasl;

import com.mapr.baseutils.JVMProperties;
import com.mapr.security.callback.MaprSaslCallbackHandler;
import com.mapr.security.maprsasl.MaprSaslProvider;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import org.apache.drill.exec.rpc.security.FastSaslClientFactory;
import org.apache.drill.exec.rpc.security.FastSaslServerFactory;
import org.apache.drill.exec.rpc.security.SecurityConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRSaslFactory
implements AuthenticatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(MapRSaslFactory.class);
    public static final String SIMPLE_NAME = "MAPRSASL";
    private static final String MECHANISM_NAME = "MAPR-SECURITY";
    private static final String SASL_DEFAULT_REALM = "default";

    public MapRSaslFactory() {
        JVMProperties.init();
    }

    public String getSimpleName() {
        return SIMPLE_NAME;
    }

    public UserGroupInformation createAndLoginUser(Map<String, ?> properties) throws IOException {
        SecurityConfiguration conf = new SecurityConfiguration();
        conf.set("hadoop.security.authentication", "CUSTOM");
        conf.set("hadoop.login", "maprsasl");
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LoginException) {
                throw new SaslException("Failed to login.", cause);
            }
            throw new SaslException("Unexpected failure trying to login.", cause);
        }
    }

    public SaslServer createSaslServer(UserGroupInformation ugi, final Map<String, ?> properties) throws SaslException {
        try {
            final String primaryName = ugi.getShortUserName();
            SaslServer saslServer = (SaslServer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws Exception {
                    AccessControlContext context = AccessController.getContext();
                    Subject subject = Subject.getSubject(context);
                    return FastSaslServerFactory.getInstance().createSaslServer(MapRSaslFactory.MECHANISM_NAME, null, MapRSaslFactory.SASL_DEFAULT_REALM, properties, (CallbackHandler)new MaprSaslCallbackHandler(subject, primaryName));
                }
            });
            logger.trace("MapRSasl SaslServer created.");
            return saslServer;
        }
        catch (UndeclaredThrowableException e) {
            throw new SaslException("Unexpected failure trying to authenticate using MapRSasl", e.getCause());
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException("Unexpected failure trying to authenticate using MapRSasl", e);
        }
    }

    public SaslClient createSaslClient(UserGroupInformation ugi, final Map<String, ?> properties) throws SaslException {
        try {
            SaslClient saslClient = (SaslClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws Exception {
                    return FastSaslClientFactory.getInstance().createSaslClient(new String[]{MapRSaslFactory.MECHANISM_NAME}, null, null, null, properties, new CallbackHandler(){

                        @Override
                        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                            throw new UnsupportedCallbackException(callbacks[0]);
                        }
                    });
                }
            });
            logger.trace("MapRSasl SaslClient created.");
            return saslClient;
        }
        catch (UndeclaredThrowableException e) {
            throw new SaslException("Unexpected failure trying to authenticate using MapRSasl", e.getCause());
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException("Unexpected failure trying to authenticate using MapRSasl", e);
        }
    }

    public void close() throws Exception {
    }

    static {
        Security.addProvider((Provider)new MaprSaslProvider());
    }
}

