/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.component.plugins.Pauseable;
import org.apache.log4j.component.plugins.Receiver;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.receivers.net.PortBased;
import org.apache.log4j.receivers.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

public class UDPReceiver
extends Receiver
implements PortBased,
Pauseable {
    private static final int PACKET_LENGTH = 16384;
    private UDPReceiverThread receiverThread;
    private String encoding;
    private String decoder = "org.apache.log4j.xml.XMLDecoder";
    private Decoder decoderImpl;
    protected boolean paused;
    private transient boolean closed = false;
    private int port;
    private DatagramSocket socket;
    UDPHandlerThread handlerThread;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;
    public static final String ZONE = "_log4j_xml_udp_receiver.local.";

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String decoder) {
        this.decoder = decoder;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.advertiseViaMulticastDNS = advertiseViaMulticastDNS;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    public synchronized void shutdown() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.active = false;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        try {
            if (this.handlerThread != null) {
                this.handlerThread.close();
                this.handlerThread.join();
            }
            if (this.receiverThread != null) {
                this.receiverThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void activateOptions() {
        try {
            Class<?> c = Class.forName(this.decoder);
            Object o = c.newInstance();
            if (o instanceof Decoder) {
                this.decoderImpl = (Decoder)o;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.getLogger().warn((Object)"Unable to find decoder", cnfe);
        }
        catch (IllegalAccessException iae) {
            this.getLogger().warn((Object)"Could not construct decoder", iae);
        }
        catch (InstantiationException ie) {
            this.getLogger().warn((Object)"Could not construct decoder", ie);
        }
        try {
            this.socket = new DatagramSocket(this.port);
            this.receiverThread = new UDPReceiverThread();
            this.receiverThread.start();
            this.handlerThread = new UDPHandlerThread();
            this.handlerThread.start();
            if (this.advertiseViaMulticastDNS) {
                this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
                this.zeroConf.advertise();
            }
            this.active = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    class UDPReceiverThread
    extends Thread {
        public UDPReceiverThread() {
            this.setDaemon(true);
        }

        public void run() {
            byte[] b = new byte[16384];
            DatagramPacket p = new DatagramPacket(b, b.length);
            while (!UDPReceiver.this.closed) {
                try {
                    UDPReceiver.this.socket.receive(p);
                    if (UDPReceiver.this.encoding == null) {
                        UDPReceiver.this.handlerThread.append(new String(p.getData(), 0, p.getLength()));
                        continue;
                    }
                    UDPReceiver.this.handlerThread.append(new String(p.getData(), 0, p.getLength(), UDPReceiver.this.encoding));
                }
                catch (SocketException socketException) {
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    class UDPHandlerThread
    extends Thread {
        private List list = new ArrayList();

        public UDPHandlerThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(String data) {
            List list = this.list;
            synchronized (list) {
                this.list.add(data);
                this.list.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            List list = this.list;
            synchronized (list) {
                this.list.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList list2 = new ArrayList();
            while (!UDPReceiver.this.closed) {
                Object object = this.list;
                synchronized (object) {
                    try {
                        while (!UDPReceiver.this.closed && this.list.size() == 0) {
                            this.list.wait(300L);
                        }
                        if (this.list.size() > 0) {
                            list2.addAll(this.list);
                            this.list.clear();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (list2.size() > 0) {
                    Iterator iter = list2.iterator();
                    while (iter.hasNext()) {
                        String data = (String)iter.next();
                        Vector v = UDPReceiver.this.decoderImpl.decodeEvents(data);
                        if (v == null) continue;
                        Iterator eventIter = v.iterator();
                        while (eventIter.hasNext()) {
                            if (UDPReceiver.this.isPaused()) continue;
                            UDPReceiver.this.doPost((LoggingEvent)eventIter.next());
                        }
                    }
                    list2.clear();
                    continue;
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            UDPReceiver.this.getLogger().debug(UDPReceiver.this.getName() + "'s handler thread is exiting");
        }
    }
}

