/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import com.google.common.base.Preconditions;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;

@Tag(value="IntegrationTest")
class JettyRequestMetricsFilterIntegrationTest {
    private ScheduledExecutorService executor;
    private Server server;
    private Client client;

    JettyRequestMetricsFilterIntegrationTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        props.setProperty("debug", "false");
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        TestApplication app = new TestApplication(config);
        app.createServer();
        this.server = app.createServer();
        this.server.start();
        this.executor = Executors.newScheduledThreadPool(4);
        this.client = ClientBuilder.newClient((Configuration)app.resourceConfig.getConfiguration());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
        this.client.close();
        this.awaitTerminationAfterShutdown(this.executor);
    }

    @RepeatedTest(value=5)
    public void test_doFilter_requestCount() {
        int warmupRequests = 10;
        int totalRequests = 20;
        int response200s = this.hammerAtConstantRate(this.server.getURI(), "/public/hello", Duration.ofMillis(1L), 10, 20);
        Assertions.assertEquals((int)10, (int)response200s);
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            Object metricValue;
            if (metric.metricName().name().equals("request-count") && metric.metricName().group().equals("jetty-metrics")) {
                Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("sampledstat"));
                metricValue = metric.metricValue();
                Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Request count metrics should be measurable");
                double count = (Double)metricValue;
                Assertions.assertEquals((double)20.0, (double)count, (String)("Actual: " + count));
            }
            if (metric.metricName().name().equals("request-total") && metric.metricName().group().equals("jetty-metrics")) {
                Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("cumulativesum"));
                metricValue = metric.metricValue();
                Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Request total metrics should be measurable");
                double total = (Double)metricValue;
                Assertions.assertEquals((double)20.0, (double)total, (String)("Actual: " + total));
            }
            if (!metric.metricName().name().equals("request-rate") || !metric.metricName().group().equals("jetty-metrics")) continue;
            Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("rate"));
            metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Request rate metrics should be measurable");
            double rate = (Double)metricValue;
            Assertions.assertEquals((double)Math.floor(0.6666666666666666), (double)Math.floor(rate), (String)("Actual: " + rate));
        }
    }

    private int hammerAtConstantRate(URI server, String path, Duration rate, int warmupRequests, int totalRequests) {
        Preconditions.checkArgument((!rate.isNegative() ? 1 : 0) != 0, (Object)"rate must be non-negative");
        Preconditions.checkArgument((warmupRequests <= totalRequests ? 1 : 0) != 0, (Object)"warmupRequests must be at most totalRequests");
        List responses = IntStream.range(0, totalRequests).mapToObj(i -> this.executor.schedule(() -> this.client.target(server).path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(), (long)i * rate.toMillis(), TimeUnit.MILLISECONDS)).collect(Collectors.toList()).stream().map(future -> {
            try {
                return (Response)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        for (Response response2 : responses) {
            int status = response2.getStatus();
            if (status == 200 || status == 429) continue;
            Assertions.fail((String)String.format("Expected HTTP 200 or HTTP 429, but got HTTP %d instead: %s", status, response2.readEntity(String.class)));
        }
        return (int)responses.subList(warmupRequests, responses.size()).stream().filter(response -> response.getStatus() == Response.Status.OK.getStatusCode()).count();
    }

    private void awaitTerminationAfterShutdown(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Produces(value={"application/json"})
    @Path(value="/public/")
    public static class PublicResource {
        @GET
        @Path(value="/hello")
        public String hello() {
            return "hello";
        }
    }

    private static class TestApplication
    extends Application<TestRestConfig> {
        Configurable<?> resourceConfig;

        TestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(PublicResource.class);
        }
    }
}

