/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.filters;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.filters.CsrfTokenProtectionFilter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CsrfProtectionFilterTest {
    private CsrfTokenProtectionFilter filter;

    @BeforeEach
    public void setUp() {
        this.filter = new CsrfTokenProtectionFilter();
    }

    @Test
    public void testHasDefaultValues() throws ServletException {
        this.filter.init((FilterConfig)new TestFilterConfig(new HashMap<String, String>()));
        Assertions.assertEquals((Object)this.filter.getCsrfTokenEndpoint(), (Object)"/csrf");
        Assertions.assertEquals((int)this.filter.getCsrfTokenExpiration(), (int)30);
        Assertions.assertEquals((int)this.filter.getCsrfTokenMaxEntries(), (int)10000);
    }

    @Test
    public void testOverrideDefaultValues() throws ServletException {
        this.filter.init((FilterConfig)new TestFilterConfig((Map<String, String>)ImmutableMap.of((Object)"csrf.prevention.token.endpoint", (Object)"/test-ep", (Object)"csrf.prevention.token.expiration.minutes", (Object)"10", (Object)"csrf.prevention.token.max.entries", (Object)"70")));
        Assertions.assertEquals((Object)"/test-ep", (Object)this.filter.getCsrfTokenEndpoint());
        Assertions.assertEquals((int)10, (int)this.filter.getCsrfTokenExpiration());
        Assertions.assertEquals((int)70, (int)this.filter.getCsrfTokenMaxEntries());
    }

    class TestFilterConfig
    implements FilterConfig {
        private Map<String, String> map = new HashMap<String, String>();

        public TestFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "test-filter";
        }

        public ServletContext getServletContext() {
            return null;
        }

        public String getInitParameter(String s) {
            return this.map.get(s);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }
    }
}

