/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GzipHandlerIntegrationTest {
    private TestRestConfig config;
    private Server server;

    @BeforeEach
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        props.setProperty("compression.enable", "true");
        props.setProperty("listeners", "http://localhost:0");
        this.config = TestRestConfig.maprCompatible(props);
        CompressibleApplication application = new CompressibleApplication(this.config);
        this.server = application.createServer();
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testGzip() {
        Response response = ClientBuilder.newClient().target(this.server.getURI()).path("/test/zeros").request(new String[]{"application/octet-stream"}).acceptEncoding(new String[]{"gzip"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"gzip", (Object)response.getHeaderString("Content-Encoding"));
    }

    @Produces(value={"application/octet-stream"})
    @Path(value="/test")
    public static class ZerosResource {
        @GET
        @Path(value="/zeros")
        public byte[] zeros() {
            return new byte[0x100000];
        }
    }

    private static class CompressibleApplication
    extends Application<TestRestConfig> {
        CompressibleApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(ZerosResource.class);
        }
    }
}

