/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.websocket.EndpointConfig;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kafka.common.Configurable;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomInitTest {
    private static final Logger log = LoggerFactory.getLogger(CustomInitTest.class);
    private static final String NEHAS_BASIC_AUTH = "bmVoYTpha2Zhaw==";
    private static final String JUNS_BASIC_AUTH = "anVuOmthZmthLQ==";
    private Server server;
    private CloseableHttpClient httpclient;

    @BeforeEach
    public void setUp() throws Exception {
        this.httpclient = HttpClients.createDefault();
        Properties props = new Properties();
        props.put("listeners", "http://localhost:0");
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        props.put("authentication.roles", "SomeRequiredRole");
        props.put("rest.servlet.initializor.classes", Collections.singletonList(CustomRestInitializer.class.getName()));
        props.put("websocket.servlet.initializor.classes", Collections.singletonList(CustomWsInitializer.class.getName()));
        CustomInitTestApplication application = new CustomInitTestApplication(TestRestConfig.maprCompatible(props));
        this.server = application.createServer();
        this.server.start();
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.httpclient.close();
        this.server.stop();
    }

    @Test
    public void shouldBeAbleToInstallSecurityHandler() throws Exception {
        try (CloseableHttpResponse response = this.makeRestGetRequest(NEHAS_BASIC_AUTH);){
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
        response = this.makeRestGetRequest(JUNS_BASIC_AUTH);
        try {
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void shouldBeAbleToAddWebSocketEndPoint() throws Exception {
        this.makeWsGetRequest();
    }

    private CloseableHttpResponse makeRestGetRequest(String basicAuth) throws Exception {
        log.debug("Making GET " + this.server.getURI() + "/test");
        HttpGet httpget = new HttpGet(this.server.getURI() + "/test");
        if (basicAuth != null) {
            httpget.setHeader("Authorization", "Basic " + basicAuth);
        }
        CloseableHttpResponse response = null;
        response = this.httpclient.execute((HttpUriRequest)httpget);
        return response;
    }

    private void makeWsGetRequest() throws Exception {
        String uri = this.server.getURI().toString().replace("http", "ws") + "ws";
        log.debug("Making WebSocket GET " + uri + "test");
        final AtomicReference error = new AtomicReference();
        WebSocketUpgradeHandler wsHandler = new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

            public void onOpen(WebSocket websocket) {
            }

            public void onClose(WebSocket websocket, int code, String reason) {
            }

            public void onError(Throwable t) {
                log.info("Websocket failed", t);
                error.set(t);
            }
        }).build();
        WebSocket ws = (WebSocket)((BoundRequestBuilder)Dsl.asyncHttpClient().prepareGet(uri + "/test").setRequestTimeout(20000)).execute((AsyncHandler)wsHandler).get();
        if (error.get() != null) {
            throw new RuntimeException("Error connecting websocket", (Throwable)error.get());
        }
        ws.sendCloseFrame();
    }

    @ServerEndpoint(value="/test")
    public static class WSEndpoint {
        @OnOpen
        public void onOpen(Session session, EndpointConfig endpointConfig) {
            session.getAsyncRemote().sendText("Test message", result -> {
                if (!result.isOK()) {
                    log.warn("Error sending websocket message for session {}", (Object)session.getId(), (Object)result.getException());
                }
            });
        }
    }

    @Path(value="/test")
    @Produces(value={"text/plain"})
    public static class CustomRestResource {
        @GET
        @Path(value="/")
        public String hello() {
            return "Hello";
        }
    }

    public static class CustomWsInitializer
    implements Consumer<ServletContextHandler> {
        @Override
        public void accept(ServletContextHandler context) {
            try {
                ServerContainer container = (ServerContainer)context.getBean(ServerContainer.class);
                container.addEndpoint(ServerEndpointConfig.Builder.create(WSEndpoint.class, (String)WSEndpoint.class.getAnnotation(ServerEndpoint.class).value()).build());
            }
            catch (Exception e) {
                Assertions.fail((String)"Invalid test");
            }
        }
    }

    private static class TestLoginService
    extends AbstractLoginService {
        private TestLoginService() {
        }

        protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
            if (user.getName().equals("jun")) {
                return new String[]{"some-role"};
            }
            if (user.getName().equals("neha")) {
                return new String[]{"SomeRequiredRole", "another"};
            }
            return new String[0];
        }

        protected AbstractLoginService.UserPrincipal loadUserInfo(String username) {
            if (username.equals("jun")) {
                return new AbstractLoginService.UserPrincipal(username, (Credential)new Password("kafka-"));
            }
            if (username.equals("neha")) {
                return new AbstractLoginService.UserPrincipal(username, (Credential)new Password("akfak"));
            }
            return null;
        }
    }

    public static class CustomRestInitializer
    implements Consumer<ServletContextHandler>,
    Configurable {
        private RestConfig config;

        public void configure(Map<String, ?> config) {
            this.config = new RestConfig(RestConfig.baseConfigDef(), config);
        }

        @Override
        public void accept(ServletContextHandler context) {
            List roles = this.config.getList("authentication.roles");
            Constraint constraint = new Constraint();
            constraint.setAuthenticate(true);
            constraint.setRoles(roles.toArray(new String[0]));
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint);
            constraintMapping.setMethod("*");
            constraintMapping.setPathSpec("/*");
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            securityHandler.addConstraintMapping(constraintMapping);
            securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
            securityHandler.setLoginService((LoginService)new TestLoginService());
            securityHandler.setRealmName("TestRealm");
            context.setSecurityHandler((SecurityHandler)securityHandler);
        }
    }

    private static class CustomInitTestApplication
    extends Application<TestRestConfig> {
        private CustomInitTestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(javax.ws.rs.core.Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new CustomRestResource());
        }
    }
}

