/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.extension.ResourceExtension;
import io.confluent.rest.metrics.RestMetricsContext;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ApplicationTest {
    private static final String REALM = "realm";
    private TestApp application;

    @BeforeEach
    public void setUp() {
        TestApp.SHUTDOWN_CALLED.set(false);
        TestRegistryExtension.CLOSE_CALLED.set(false);
    }

    @BeforeEach
    public void setup() throws Exception {
        this.application = new TestApp(new Class[0]);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.application.stop();
    }

    @Test
    public void testParseListenersDeprecated() {
        ArrayList listenersConfig = new ArrayList();
        List listeners = Application.parseListeners(listenersConfig, (int)8080, (List)RestConfig.SUPPORTED_URI_SCHEMES, (String)"http");
        Assertions.assertEquals((int)1, (int)listeners.size(), (String)"Should have only one listener.");
        this.assertExpectedUri((URI)listeners.get(0), "http", "0.0.0.0", 8080);
    }

    @Test
    public void testParseListenersHttpAndHttps() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:123");
        listenersConfig.add("https://localhost:124");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, (List)RestConfig.SUPPORTED_URI_SCHEMES, (String)"http");
        Assertions.assertEquals((int)2, (int)listeners.size(), (String)"Should have two listeners.");
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 123);
        this.assertExpectedUri((URI)listeners.get(1), "https", "localhost", 124);
    }

    @Test
    public void testParseListenersUnparseableUri() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("!");
        Assertions.assertThrows(ConfigException.class, () -> Application.parseListeners((List)listenersConfig, (int)-1, (List)RestConfig.SUPPORTED_URI_SCHEMES, (String)"http"));
    }

    @Test
    public void testParseListenersUnsupportedScheme() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:8080");
        listenersConfig.add("foo://localhost:8081");
        Assertions.assertThrows(ConfigException.class, () -> Application.parseListeners((List)listenersConfig, (int)-1, (List)RestConfig.SUPPORTED_URI_SCHEMES, (String)"http"));
    }

    public void testParseListenersNoSupportedListeners() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("foo://localhost:8080");
        listenersConfig.add("bar://localhost:8081");
        Assertions.assertThrows(ConfigException.class, () -> Application.parseListeners((List)listenersConfig, (int)-1, (List)RestConfig.SUPPORTED_URI_SCHEMES, (String)"http"));
    }

    @Test
    public void testParseListenersNoPort() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost");
        Assertions.assertThrows(ConfigException.class, () -> Application.parseListeners((List)listenersConfig, (int)-1, (List)RestConfig.SUPPORTED_URI_SCHEMES, (String)"http"));
    }

    @Test
    public void testAuthEnabledNONE() {
        Assertions.assertFalse((boolean)Application.enableBasicAuth((String)"NONE"));
    }

    @Test
    public void testAuthEnabledBASIC() {
        Assertions.assertTrue((boolean)Application.enableBasicAuth((String)"BASIC"));
    }

    @Test
    public void testAuthEnabledBEARER() {
        Assertions.assertTrue((boolean)Application.enableBearerAuth((String)"BEARER"));
    }

    @Test
    public void testCreateSecurityHandlerWithNoRoles() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.method", (Object)"BASIC", (Object)"authentication.realm", (Object)REALM, (Object)"authentication.roles", (Object)"");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        Assertions.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assertions.assertTrue((boolean)securityHandler.getRoles().isEmpty());
        Assertions.assertNotNull((Object)securityHandler.getLoginService());
        Assertions.assertNotNull((Object)securityHandler.getAuthenticator());
        Assertions.assertEquals((int)1, (int)securityHandler.getConstraintMappings().size());
        Assertions.assertFalse((boolean)((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint().isAnyRole());
    }

    @Test
    public void testCreateSecurityHandlerWithAllRoles() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.method", (Object)"BASIC", (Object)"authentication.realm", (Object)REALM, (Object)"authentication.roles", (Object)"*");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        Assertions.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assertions.assertTrue((boolean)securityHandler.getRoles().isEmpty());
        Assertions.assertNotNull((Object)securityHandler.getLoginService());
        Assertions.assertNotNull((Object)securityHandler.getAuthenticator());
        Assertions.assertEquals((int)1, (int)securityHandler.getConstraintMappings().size());
        Assertions.assertTrue((boolean)((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint().isAnyRole());
    }

    @Test
    public void testCreateSecurityHandlerWithSpecificRoles() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.method", (Object)"BASIC", (Object)"authentication.realm", (Object)REALM, (Object)"authentication.roles", (Object)"roleA, roleB");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        Assertions.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assertions.assertFalse((boolean)securityHandler.getRoles().isEmpty());
        Assertions.assertNotNull((Object)securityHandler.getLoginService());
        Assertions.assertNotNull((Object)securityHandler.getAuthenticator());
        Assertions.assertEquals((int)1, (int)securityHandler.getConstraintMappings().size());
        Constraint constraint = ((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint();
        Assertions.assertFalse((boolean)constraint.isAnyRole());
        Assertions.assertEquals((int)constraint.getRoles().length, (int)2);
        Assertions.assertArrayEquals((Object[])constraint.getRoles(), (Object[])new String[]{"roleA", "roleB"});
    }

    @Test
    public void testSetUnsecurePathConstraintsWithUnSecure() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.skip.paths", (Object)"/path/1,/path/2");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        List mappings = securityHandler.getConstraintMappings();
        MatcherAssert.assertThat((Object)mappings.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/path/1"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(2)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/path/2"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(2)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testConstraintsWhenOptionsRequestNotAllowedAndSecurityOn() {
        ImmutableMap config = ImmutableMap.of((Object)"reject.options.request", (Object)true);
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        List mappings = securityHandler.getConstraintMappings();
        MatcherAssert.assertThat((Object)mappings.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getMethodOmissions(), (Matcher)CoreMatchers.is((Object)new String[]{"OPTIONS"}));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getConstraint().isAnyRole(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getMethod(), (Matcher)CoreMatchers.is((Object)"OPTIONS"));
    }

    @Test
    public void testConstraintsWhenOptionsRequestNotAllowedAndSecurityOff() {
        ImmutableMap config = ImmutableMap.of((Object)"reject.options.request", (Object)true);
        TestApp app = new TestApp((Map<String, Object>)config);
        ServletContextHandler context = new ServletContextHandler();
        app.configureSecurityHandler(context);
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)context.getSecurityHandler();
        List mappings = securityHandler.getConstraintMappings();
        MatcherAssert.assertThat((Object)mappings.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getConstraint().isAnyRole(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getMethod(), (Matcher)CoreMatchers.is((Object)"OPTIONS"));
    }

    @Test
    public void testBearerNoAuthenticator() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.method", (Object)"BEARER");
        TestApp app = new TestApp((Map)config){

            protected LoginService createLoginService() {
                return new JAASLoginService(ApplicationTest.REALM);
            }
        };
        Assertions.assertThrows(UnsupportedOperationException.class, () -> app.createBearerSecurityHandler());
    }

    @Test
    public void testBearerNoLoginService() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.method", (Object)"BEARER");
        TestApp app = new TestApp((Map)config){

            protected LoginAuthenticator createAuthenticator() {
                return new BasicAuthenticator();
            }
        };
        Assertions.assertThrows(UnsupportedOperationException.class, () -> app.createBearerSecurityHandler());
    }

    @Test
    public void testBearerNoAuthenticatorNoLoginService() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.method", (Object)"BEARER");
        TestApp app = new TestApp((Map<String, Object>)config);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> app.createBearerSecurityHandler());
    }

    @Test
    public void shouldInitializeResourceExtensions() throws Exception {
        try (TestApp testApp = new TestApp(new Class[]{TestRegistryExtension.class});){
            MatcherAssert.assertThat((Object)this.makeGetRequest(testApp, "/custom/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
        }
    }

    @Test
    public void shouldThrowIfResourceExtensionThrows() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> new TestApp(new Class[]{TestRegistryExtension.class, BadRegistryExtension.class}));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Exception throw by resource extension. ext:"));
    }

    @Test
    public void shouldCloseResourceExtensions() throws Exception {
        new TestApp(new Class[]{TestRegistryExtension.class}).stop();
        MatcherAssert.assertThat((String)"close called", (Object)TestRegistryExtension.CLOSE_CALLED.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldShutdownProperlyEvenIfResourceExtensionThrowsOnShutdown() throws Exception {
        TestApp testApp = new TestApp(new Class[]{UnstoppableRegistryExtension.class});
        testApp.stop();
        testApp.join();
        MatcherAssert.assertThat((String)"shutdown called", (Object)TestApp.SHUTDOWN_CALLED.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDefaultMetricsContext() throws Exception {
        TestApp testApp = new TestApp(new Class[0]);
        Assertions.assertEquals((Object)testApp.metricsContext().getLabel("resource.type"), (Object)"rest-utils");
        Assertions.assertEquals((Object)testApp.metricsContext().getLabel("_namespace"), (Object)"rest-utils");
    }

    @Test
    public void testMetricsContextResourceOverride() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("metrics.context.resource.type", "FooApp");
        TestApp testApp = new TestApp(props);
        Assertions.assertEquals((Object)testApp.metricsContext().getLabel("resource.type"), (Object)"FooApp");
        Assertions.assertEquals((Object)testApp.metricsContext().getLabel("_namespace"), (Object)"rest-utils");
        String jmx_domain = "rest-utils";
        String mbean_name = String.format("%s:type=kafka-metrics-count", jmx_domain);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Assertions.assertNotNull((Object)server.getObjectInstance(new ObjectName(mbean_name)));
    }

    @Test
    public void testMetricsContextJMXPrefixPropagation() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("metrics.jmx.prefix", "FooApp");
        TestApp testApp = new TestApp(props);
        Assertions.assertEquals((Object)testApp.metricsContext().getLabel("resource.type"), (Object)"FooApp");
        Assertions.assertEquals((Object)testApp.metricsContext().getLabel("_namespace"), (Object)"FooApp");
    }

    @Test
    public void testMetricsContextJMXBeanRegistration() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("metrics.jmx.prefix", "FooApp");
        new TestApp(props);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Assertions.assertNotNull((Object)server.getObjectInstance(new ObjectName("FooApp:type=kafka-metrics-count")));
    }

    private void assertExpectedUri(URI uri, String scheme, String host, int port) {
        Assertions.assertEquals((Object)scheme, (Object)uri.getScheme(), (String)("Scheme should be " + scheme));
        Assertions.assertEquals((Object)host, (Object)uri.getHost(), (String)("Host should be " + host));
        Assertions.assertEquals((int)port, (int)uri.getPort(), (String)("Port should be " + port));
    }

    private HttpStatus.Code makeGetRequest(TestApp app, String path) throws Exception {
        HttpGet httpget = new HttpGet(((URL)app.getListeners().get(0)).toString() + path);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpStatus.Code code;
            block12: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                try {
                    code = HttpStatus.getCode((int)response.getStatusLine().getStatusCode());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return code;
        }
    }

    public static class UnstoppableRegistryExtension
    implements ResourceExtension<Application<?>> {
        public void register(Configurable<?> config, Application<?> app) {
        }

        public void close() throws IOException {
            throw new IOException("Boom");
        }
    }

    public static class BadRegistryExtension
    implements ResourceExtension<Application<?>> {
        public void register(Configurable<?> config, Application<?> app) {
            throw new IllegalArgumentException("Boom");
        }
    }

    public static class TestRegistryExtension
    implements ResourceExtension<TestApp> {
        private static final AtomicBoolean CLOSE_CALLED = new AtomicBoolean(true);

        public void register(Configurable<?> config, TestApp app) {
            TestRestConfig restConfig = (TestRestConfig)app.getConfiguration();
            Assertions.assertNotNull((Object)((Object)restConfig));
            config.register((Object)new RestResource());
        }

        public void close() {
            CLOSE_CALLED.set(true);
        }
    }

    @Path(value="/custom")
    @Produces(value={"text/plain"})
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }
    }

    private static class TestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(true);

        @SafeVarargs
        private TestApp(Class<? extends ResourceExtension> ... extensions) throws Exception {
            super((RestConfig)TestApp.createConfig(extensions));
            this.start();
        }

        public TestApp(Map<String, Object> config) {
            super((RestConfig)TestApp.createConfig(config));
        }

        public RestMetricsContext metricsContext() {
            return ((TestRestConfig)this.getConfiguration()).getMetricsContext();
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public void onShutdown() {
            SHUTDOWN_CALLED.set(true);
        }

        private List<URL> getListeners() {
            return Arrays.stream(this.getServer().getConnectors()).filter(connector -> connector instanceof ServerConnector).map(ServerConnector.class::cast).map(connector -> {
                try {
                    String protocol = new HashSet(connector.getProtocols()).stream().map(String::toLowerCase).anyMatch(s -> s.equals("ssl")) ? "https" : "http";
                    int localPort = connector.getLocalPort();
                    return new URL(protocol, "localhost", localPort, "");
                }
                catch (Exception e) {
                    throw new RuntimeException("Malformed listener", e);
                }
            }).collect(Collectors.toList());
        }

        @SafeVarargs
        private static TestRestConfig createConfig(Class<? extends ResourceExtension> ... exts) {
            String extensionList = Arrays.stream(exts).map(Class::getName).collect(Collectors.joining(","));
            return TestApp.createConfig(Collections.singletonMap("resource.extension.classes", extensionList));
        }

        private static TestRestConfig createConfig(Map<String, Object> props) {
            HashMap<String, Object> config = new HashMap<String, Object>(props);
            config.put("listeners", "http://0.0.0.0:0");
            return TestRestConfig.maprCompatible(config);
        }
    }
}

