/**
 * Copyright 2019 Confluent Inc.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at</p>
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0</p>
 *
 * <p>Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.</p>
 */

package io.confluent.rest.impersonation;

import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestNotAuthorizedException;
import io.confluent.rest.exceptions.RestServerErrorException;

import javax.ws.rs.core.Response;

public class Errors {
  private static final int ERROR_CODE = RestServerErrorException.DEFAULT_ERROR_CODE;
  private static final int DEFAULT_ERROR_CODE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();

  public static RestException maprTicketDecryptException(final String message) {
    return new RestNotAuthorizedException(message, ERROR_CODE);
  }

  public static RestException maprTicketDecryptException(final String message,
                                                         final Throwable cause) {
    return new RestNotAuthorizedException(message, ERROR_CODE, cause);
  }

  public static RestServerErrorException serverLoginException(Throwable cause) {
    return new RestServerErrorException("Login fails", DEFAULT_ERROR_CODE, cause);
  }

  public static RestServerErrorException serverLoginException(final String message,
                                                              final Throwable cause) {
    return new RestServerErrorException(message, DEFAULT_ERROR_CODE, cause);
  }
}
