/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.metrics.JettyRequestMetricsFilter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class JettyRequestMetricsFilterTest {
    private static final String TEST_JMX_PREFIX = "test-kafka-rest";
    private final Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
    private final Sensor sensor = (Sensor)Mockito.mock(Sensor.class);
    private final Map<String, String> allTags = new HashMap<String, String>();
    private Filter jettyRequestMetricsFilter;

    JettyRequestMetricsFilterTest() {
    }

    @Test
    public void test_doFilter_nullMetrics() throws Exception {
        this.jettyRequestMetricsFilter = new JettyRequestMetricsFilter(null, (Map)ImmutableMap.of(), TEST_JMX_PREFIX);
        this.jettyRequestMetricsFilter.doFilter((ServletRequest)Mockito.mock(ServletRequest.class), (ServletResponse)Mockito.mock(ServletResponse.class), (FilterChain)Mockito.mock(FilterChain.class));
        ((Sensor)Mockito.verify((Object)this.sensor, (VerificationMode)Mockito.never())).add((MetricName)ArgumentMatchers.any(MetricName.class), (MeasurableStat)ArgumentMatchers.any());
        ((Sensor)Mockito.verify((Object)this.sensor, (VerificationMode)Mockito.never())).record();
    }

    @Test
    public void test_doFilter_metricsNotNull() throws Exception {
        this.setMockedMetricsObjectResponses(this.allTags);
        this.jettyRequestMetricsFilter = new JettyRequestMetricsFilter(this.metrics, (Map)ImmutableMap.of(), TEST_JMX_PREFIX);
        this.jettyRequestMetricsFilter.doFilter((ServletRequest)Mockito.mock(ServletRequest.class), (ServletResponse)Mockito.mock(ServletResponse.class), (FilterChain)Mockito.mock(FilterChain.class));
        ((Sensor)Mockito.verify((Object)this.sensor, (VerificationMode)Mockito.times((int)3))).add((MetricName)ArgumentMatchers.any(MetricName.class), (MeasurableStat)ArgumentMatchers.any(MeasurableStat.class));
        this.verifySensor(this.sensor, this.allTags, 1);
    }

    private void setMockedMetricsObjectResponses(Map<String, String> allTags) {
        MetricName rateName = new MetricName("request-rate", "jetty-metrics", "The average number of requests per second in Jetty layer", allTags);
        Mockito.when((Object)this.metrics.metricInstance(new MetricNameTemplate("request-rate", "jetty-metrics", "The average number of requests per second in Jetty layer", allTags.keySet()), allTags)).thenReturn((Object)rateName);
        MetricName countName = new MetricName("request-count", "jetty-metrics", "A windowed count of requests in Jetty layer", allTags);
        Mockito.when((Object)this.metrics.metricInstance(new MetricNameTemplate("request-count", "jetty-metrics", "A windowed count of requests in Jetty layer", allTags.keySet()), allTags)).thenReturn((Object)countName);
        MetricName cumulativeCountName = new MetricName("request-total", "jetty-metrics", "A cumulative count of requests in Jetty layer", allTags);
        Mockito.when((Object)this.metrics.metricInstance(new MetricNameTemplate("request-total", "jetty-metrics", "A cumulative count of requests in Jetty layer", allTags.keySet()), allTags)).thenReturn((Object)cumulativeCountName);
        Mockito.when((Object)this.metrics.sensor(ArgumentMatchers.anyString(), (MetricConfig)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (Sensor.RecordingLevel)ArgumentMatchers.any(Sensor.RecordingLevel.class), (Sensor[])ArgumentMatchers.any())).thenReturn((Object)this.sensor);
    }

    private void verifySensor(Sensor sensor, Map<String, String> allTags, int timesRecorded) {
        MetricName rateName = new MetricName("request-rate", "jetty-metrics", "The average number of requests per second in Jetty layer", allTags);
        MetricName countName = new MetricName("request-count", "jetty-metrics", "A windowed count of requests in Jetty layer", allTags);
        MetricName cumulativeCountName = new MetricName("request-total", "jetty-metrics", "A cumulative count of requests in Jetty layer", allTags);
        ((Sensor)Mockito.verify((Object)sensor)).add((MetricName)ArgumentMatchers.eq((Object)rateName), (MeasurableStat)ArgumentMatchers.any(Rate.class));
        ((Sensor)Mockito.verify((Object)sensor)).add((MetricName)ArgumentMatchers.eq((Object)countName), (MeasurableStat)ArgumentMatchers.any(SampledStat.class));
        ((Sensor)Mockito.verify((Object)sensor)).add((MetricName)ArgumentMatchers.eq((Object)cumulativeCountName), (MeasurableStat)ArgumentMatchers.any(CumulativeSum.class));
        ((Sensor)Mockito.verify((Object)sensor, (VerificationMode)Mockito.times((int)timesRecorded))).record();
    }
}

