/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.auth;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import io.confluent.rest.auth.MaprAuthenticationUtils;
import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.impersonation.Errors;
import io.confluent.rest.mapr.test.TestUtils;
import java.io.IOException;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareOnlyThisForTest(value={Security.class})
public class MaprAuthenticationUtilsTest {
    private static final int SOME_NATIVE_ERROR_CODE = 123;
    private static final String MAPR_USER_1_BASIC = "Basic " + Base64.encodeBase64String((byte[])"mapruser1:pass".getBytes());
    private static final String MAPRUSER_1 = "mapruser1";
    private static final String MAPR_USER_1_COOKIE_VALUE = "whatever&u=mapruser1";
    private static final String HADOOP_AUTH_NAME = "hadoop.auth";
    private static final String MAPR_USER_1_COOKIE = "hadoop.auth=whatever&u=mapruser1";

    @Test
    public void decryptsBasicUserName() {
        String userName = MaprAuthenticationUtils.findUserNameFromAuthentication((String)MAPR_USER_1_BASIC).orElse(null);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)userName);
    }

    @Test
    public void emptyResultOnUnsupportedHeader() {
        Optional result = MaprAuthenticationUtils.findUserNameFromAuthentication((String)"Something unsupported");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void emptyResultOnEmptyHeader() {
        Optional result = MaprAuthenticationUtils.findUserNameFromAuthentication((String)"");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void findsCookieUserName() {
        String userName = MaprAuthenticationUtils.findUserNameFromCookie((String)MAPR_USER_1_COOKIE).orElse(null);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)userName);
    }

    @Test
    public void emptyResultOnMissingHadoopAuthCookie() {
        String cookie = "another.auth=whatever&u=mapruser1";
        Optional userName = MaprAuthenticationUtils.findUserNameFromCookie((String)cookie);
        Assert.assertFalse((boolean)userName.isPresent());
    }

    @Test
    public void emptyResultOnMissingCookieUser() {
        String cookie = "hadoop.auth=whatever&l=mapruser1";
        Optional userName = MaprAuthenticationUtils.findUserNameFromCookie((String)cookie);
        Assert.assertFalse((boolean)userName.isPresent());
    }

    @Test
    public void decryptsTicketUserName() {
        String expectedUserName = MAPRUSER_1;
        byte[] encryptedTicketBytes = "encrypted-ticket".getBytes();
        Security.AuthenticationReqFull request = Security.AuthenticationReqFull.newBuilder().setEncryptedTicket(ByteString.copyFrom((byte[])encryptedTicketBytes)).build();
        PowerMock.mockStatic(Security.class);
        EasyMock.expect((Object)Security.DecryptTicket((byte[])EasyMock.aryEq((byte[])encryptedTicketBytes), (MutableInt)((MutableInt)EasyMock.anyObject()))).andReturn((Object)Security.Ticket.newBuilder().setUserCreds(Security.CredentialsMsg.newBuilder().setUserName(expectedUserName).build()).build());
        PowerMock.replay((Object[])new Object[]{Security.class});
        String authenticationHeader = "MAPR-Negotiate " + Base64.encodeBase64String((byte[])request.toByteArray());
        String userName = MaprAuthenticationUtils.findUserNameFromAuthentication((String)authenticationHeader).orElse(null);
        Assert.assertEquals((Object)expectedUserName, (Object)userName);
    }

    @Test
    public void failsOnDecryptTicketErrors() {
        byte[] encryptedTicketBytes = "encrypted-ticket".getBytes();
        Security.AuthenticationReqFull request = Security.AuthenticationReqFull.newBuilder().setEncryptedTicket(ByteString.copyFrom((byte[])encryptedTicketBytes)).build();
        PowerMock.mockStatic(Security.class);
        Capture errorCapture = Capture.newInstance();
        EasyMock.expect((Object)Security.DecryptTicket((byte[])EasyMock.aryEq((byte[])encryptedTicketBytes), (MutableInt)((MutableInt)EasyMock.capture((Capture)errorCapture)))).andAnswer(() -> {
            ((MutableInt)errorCapture.getValue()).SetValue(123);
            return null;
        });
        PowerMock.replay((Object[])new Object[]{Security.class});
        String authenticationHeader = "MAPR-Negotiate " + Base64.encodeBase64String((byte[])request.toByteArray());
        TestUtils.assertThatThrownRestException(() -> MaprAuthenticationUtils.findUserNameFromAuthentication((String)authenticationHeader), (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs(Errors.maprTicketDecryptException((String)"ignored")), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)String.valueOf(123)))));
    }

    @Test
    public void failsOnMalformedMaprAuthRequest() {
        Security.AuthenticationReqFull request = Security.AuthenticationReqFull.newBuilder().build();
        String authenticationHeader = "MAPR-Negotiate " + Base64.encodeBase64String((byte[])request.toByteArray());
        TestUtils.assertThatThrownRestException(() -> MaprAuthenticationUtils.findUserNameFromAuthentication((String)authenticationHeader), (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs(Errors.maprTicketDecryptException((String)"ignored")), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"request"))));
    }

    @Test
    public void failsOnInvalidProtocolBuffer() {
        String authenticationHeader = "MAPR-Negotiate " + Base64.encodeBase64String((byte[])"Something incorrect".getBytes());
        TestUtils.assertThatThrownRestException(() -> MaprAuthenticationUtils.findUserNameFromAuthentication((String)authenticationHeader), (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs(Errors.maprTicketDecryptException((String)"ignored")), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(InvalidProtocolBufferException.class))));
    }

    @Test
    public void failsWhenUnableToDetermineUserByCookieAndAuth() {
        TestUtils.assertThatThrownRestException(() -> MaprAuthenticationUtils.getUserNameFromAuthenticationOrCookie(null, null), (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs((RestException)Errors.serverLoginException((Throwable)new IOException())), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(IOException.class))));
    }

    @Test
    public void getsUserByCookieAndAuth() {
        String username = MaprAuthenticationUtils.getUserNameFromAuthenticationOrCookie((String)MAPR_USER_1_BASIC, (String)MAPR_USER_1_COOKIE);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)username);
    }

    @Test
    public void getsUserByCookieAndEmptyAuth() {
        String username = MaprAuthenticationUtils.getUserNameFromAuthenticationOrCookie(null, (String)MAPR_USER_1_COOKIE);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)username);
    }

    @Test
    public void getsUserByEmptyCookieAndAuth() {
        String username = MaprAuthenticationUtils.getUserNameFromAuthenticationOrCookie((String)MAPR_USER_1_BASIC, null);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)username);
    }

    @Test
    public void failsWhenUnableToDetermineUserByJaxrsCookieAndAuth() {
        ContainerRequestContext request = (ContainerRequestContext)EasyMock.mock(ContainerRequestContext.class);
        EasyMock.expect((Object)request.getHeaderString("Authorization")).andReturn(null);
        EasyMock.expect((Object)request.getCookies()).andReturn(null);
        PowerMock.replay((Object[])new Object[]{request});
        TestUtils.assertThatThrownRestException(() -> MaprAuthenticationUtils.getUserNameFromRequestContext((ContainerRequestContext)request), (Matcher<RestException>)CoreMatchers.allOf(TestUtils.hasSameRestAttributesAs((RestException)Errors.serverLoginException((Throwable)new IOException())), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(IOException.class))));
        EasyMock.verify((Object[])new Object[]{request});
    }

    @Test
    public void getsUserByJaxrsCookieAndAuth() {
        ContainerRequestContext request = (ContainerRequestContext)EasyMock.mock(ContainerRequestContext.class);
        EasyMock.expect((Object)request.getHeaderString("Authorization")).andReturn((Object)MAPR_USER_1_BASIC);
        EasyMock.expect((Object)request.getCookies()).andReturn((Object)ImmutableMap.of((Object)HADOOP_AUTH_NAME, (Object)new Cookie(HADOOP_AUTH_NAME, MAPR_USER_1_COOKIE_VALUE)));
        PowerMock.replay((Object[])new Object[]{request});
        String username = MaprAuthenticationUtils.getUserNameFromRequestContext((ContainerRequestContext)request);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)username);
    }

    @Test
    public void getsUserByJaxrsCookieAndEmptyAuth() {
        ContainerRequestContext request = (ContainerRequestContext)EasyMock.mock(ContainerRequestContext.class);
        EasyMock.expect((Object)request.getHeaderString("Authorization")).andReturn(null);
        EasyMock.expect((Object)request.getCookies()).andReturn((Object)ImmutableMap.of((Object)HADOOP_AUTH_NAME, (Object)new Cookie(HADOOP_AUTH_NAME, MAPR_USER_1_COOKIE_VALUE)));
        PowerMock.replay((Object[])new Object[]{request});
        String username = MaprAuthenticationUtils.getUserNameFromRequestContext((ContainerRequestContext)request);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)username);
        EasyMock.verify((Object[])new Object[]{request});
    }

    @Test
    public void getsUserByJaxrsEmptyCookieAndAuth() {
        ContainerRequestContext request = (ContainerRequestContext)EasyMock.mock(ContainerRequestContext.class);
        EasyMock.expect((Object)request.getHeaderString("Authorization")).andReturn((Object)MAPR_USER_1_BASIC);
        PowerMock.replay((Object[])new Object[]{request});
        String username = MaprAuthenticationUtils.getUserNameFromRequestContext((ContainerRequestContext)request);
        Assert.assertEquals((Object)MAPRUSER_1, (Object)username);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

