/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.test.TestSslUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2Test {
    private static final Logger log = LoggerFactory.getLogger(Http2Test.class);
    private File trustStore;
    private File clientKeystore;
    private File serverKeystore;
    private static final String HTTP_URI = "http://localhost:8080";
    private static final String HTTPS_URI = "https://localhost:8081";
    private static final String SSL_PASSWORD = "test1234";
    private static final String EXPECTED_200_MSG = "Response status must be 200.";

    @BeforeEach
    public void setUp() throws Exception {
        try {
            this.trustStore = File.createTempFile("Http2Test-truststore", ".jks");
            this.clientKeystore = File.createTempFile("Http2Test-client-keystore", ".jks");
            this.serverKeystore = File.createTempFile("Http2Test-server-keystore", ".jks");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary files for trust stores and keystores.");
        }
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        this.createKeystoreWithCert(this.clientKeystore, "client", certs);
        this.createKeystoreWithCert(this.serverKeystore, "server", certs);
        TestSslUtils.createTrustStore((String)this.trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
        TestMetricsReporter.reset();
    }

    private void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"localhost"}).generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    private void configServerKeystore(Properties props) {
        props.put("ssl.keystore.location", this.serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
    }

    private TestRestConfig buildTestConfig(boolean enableHttp2) {
        return this.buildTestConfig(enableHttp2, null, null);
    }

    private TestRestConfig buildTestConfig(boolean enableHttp2, String sslProtocol, String sslProvider) {
        Properties props = new Properties();
        props.put("listeners", "http://localhost:8080,https://localhost:8081");
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        if (!enableHttp2) {
            props.put("http2.enabled", (Object)false);
        }
        if (sslProtocol != null) {
            props.put("ssl.protocol", sslProtocol);
        }
        if (sslProvider != null) {
            props.put("ssl.provider", sslProvider);
        }
        this.configServerKeystore(props);
        return TestRestConfig.maprCompatible(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2() throws Exception {
        TestRestConfig config = this.buildTestConfig(true);
        Http2TestApplication app = new Http2TestApplication(config);
        try {
            int statusCode;
            app.start();
            if (ApplicationServer.isJava11Compatible()) {
                statusCode = this.makeGetRequestHttp2("http://localhost:8080/test");
                Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
                statusCode = this.makeGetRequestHttp2("https://localhost:8081/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            }
            statusCode = this.makeGetRequestHttp("http://localhost:8080/test");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequestHttp("https://localhost:8081/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2WithConscrypt() throws Exception {
        TestRestConfig config = this.buildTestConfig(true, "TLSv1.3", "Conscrypt");
        Http2TestApplication app = new Http2TestApplication(config);
        try {
            app.start();
            Assertions.assertTrue((boolean)ApplicationServer.isHttp2Compatible((SslConfig)config.getBaseSslConfig()));
            int statusCode = this.makeGetRequestHttp2("http://localhost:8080/test");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequestHttp2("https://localhost:8081/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequestHttp("http://localhost:8080/test");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequestHttp("https://localhost:8081/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2AmbiguousSegment() throws Exception {
        TestRestConfig config = this.buildTestConfig(true);
        Http2TestApplication app = new Http2TestApplication(config);
        try {
            int statusCode;
            app.start();
            if (ApplicationServer.isJava11Compatible()) {
                statusCode = this.makeGetRequestHttp2("http://localhost:8080/test%2fambiguous%2fsegment");
                Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
                statusCode = this.makeGetRequestHttp2("https://localhost:8081/test%2fambiguous%2fsegment", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            }
            statusCode = this.makeGetRequestHttp("http://localhost:8080/test%2fambiguous%2fsegment");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequestHttp("https://localhost:8081/test%2fambiguous%2fsegment", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2CNotEnabled() throws Exception {
        TestRestConfig config = this.buildTestConfig(false);
        Http2TestApplication app = new Http2TestApplication(config);
        try {
            app.start();
            try {
                int statusCode = this.makeGetRequestHttp2("http://localhost:8080/test");
                Assertions.fail((String)"HTTP/2 Cleartext should not be enabled");
            }
            catch (ExecutionException exc) {
                int statusCode = this.makeGetRequestHttp("http://localhost:8080/test");
                Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            }
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2NotEnabled() throws Exception {
        TestRestConfig config = this.buildTestConfig(false);
        Http2TestApplication app = new Http2TestApplication(config);
        try {
            app.start();
            try {
                int statusCode = this.makeGetRequestHttp2("https://localhost:8081/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                Assertions.fail((String)"HTTP/2 Cleartext should not be enabled");
            }
            catch (ExecutionException exc) {
                int statusCode = this.makeGetRequestHttp("https://localhost:8081/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            }
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    private void assertMetricsCollected() {
        Assertions.assertNotEquals((int)0, (int)TestMetricsReporter.getMetricTimeseries().size(), (String)"Expected to have metrics.");
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().name().equals("request-latency-max")) continue;
            Object metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Request latency metrics should be measurable");
            double latencyMaxValue = (Double)metricValue;
            Assertions.assertNotEquals((double)0.0, (double)latencyMaxValue, (String)"Metrics should be collected (max latency shouldn't be 0)");
        }
    }

    private SslContextFactory buildSslContextFactory(String clientKeystoreLocation, String clientKeystorePassword, String clientKeyPassword) throws Exception {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
        if (clientKeystoreLocation != null) {
            sslContextBuilder.loadKeyMaterial(new File(clientKeystoreLocation), clientKeystorePassword.toCharArray(), clientKeyPassword.toCharArray());
        }
        SSLContext sslContext = sslContextBuilder.build();
        sslContextFactory.setSslContext(sslContext);
        return sslContextFactory;
    }

    private int makeGetRequestHttp(String url) throws Exception {
        log.debug("Making GET using HTTP " + url);
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        int statusCode = httpClient.GET(url).getStatus();
        httpClient.stop();
        return statusCode;
    }

    private int makeGetRequestHttp(String url, String clientKeystoreLocation, String clientKeystorePassword, String clientKeyPassword) throws Exception {
        log.debug("Making GET using HTTPS " + url);
        HttpClient httpClient = new HttpClient(this.buildSslContextFactory(clientKeystoreLocation, clientKeystorePassword, clientKeyPassword));
        httpClient.start();
        int statusCode = httpClient.GET(url).getStatus();
        httpClient.stop();
        return statusCode;
    }

    private int makeGetRequestHttp2(String url) throws Exception {
        log.debug("Making GET using HTTP over HTTP/2 Cleartext " + url);
        HTTP2Client http2Client = new HTTP2Client();
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP2(http2Client));
        httpClient.start();
        int statusCode = httpClient.GET(url).getStatus();
        httpClient.stop();
        return statusCode;
    }

    private int makeGetRequestHttp2(String url, String clientKeystoreLocation, String clientKeystorePassword, String clientKeyPassword) throws Exception {
        log.debug("Making GET using HTTP/2 " + url);
        HTTP2Client http2Client = new HTTP2Client();
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP2(http2Client), this.buildSslContextFactory(clientKeystoreLocation, clientKeystorePassword, clientKeyPassword));
        httpClient.start();
        int statusCode = httpClient.GET(url).getStatus();
        httpClient.stop();
        return statusCode;
    }

    @Path(value="/test%2Fambiguous%2Fsegment")
    @Produces(value={"application/test.v1+json"})
    public static class Http2TestAmbiguousSegmentResource {
        @GET
        public Http2TestAmbiguousSegmentResponse hello() {
            return new Http2TestAmbiguousSegmentResponse();
        }

        public static class Http2TestAmbiguousSegmentResponse {
            @JsonProperty
            public String getMessage() {
                return "foo";
            }
        }
    }

    @Path(value="/test")
    @Produces(value={"application/test.v1+json"})
    public static class Http2TestResource {
        @GET
        @PerformanceMetric(value="test")
        public Http2TestResponse hello() {
            return new Http2TestResponse();
        }

        public static class Http2TestResponse {
            @JsonProperty
            public String getMessage() {
                return "foo";
            }
        }
    }

    private static class Http2TestApplication
    extends Application<TestRestConfig> {
        public Http2TestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new Http2TestResource());
            config.register((Object)new Http2TestAmbiguousSegmentResource());
        }

        public Map<String, String> getMetricsTags() {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("instance-id", "1");
            return tags;
        }
    }
}

