/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.TestUtils;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Configurable;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ErrorHandlerIntegrationTest {
    private static final String DUMMY_EXCEPTION = "dummy exception";
    private Server server;
    private HttpClient httpClient;
    private Properties props;
    private File clientKeystore;
    public static final String SSL_PASSWORD = "test1234";

    @BeforeEach
    public void setUp() {
        this.props = new Properties();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.httpClient.stop();
        this.server.stop();
        this.server.join();
    }

    @Test
    public void test_http_unhandledServerExceptionDisplaysStackTraceForInvalidAuthentication() throws Exception {
        this.props.setProperty("suppress.stack.trace.response", "false");
        this.startHttpServer("http");
        this.startHttpClient("http");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/test/path").accept(new String[]{"text/html"}).send();
        String responseValue = response.getContentAsString();
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertTrue((boolean)responseValue.toLowerCase().contains(DUMMY_EXCEPTION));
        Assertions.assertTrue((boolean)responseValue.toLowerCase().contains("caused by"));
    }

    @Test
    public void test_https_unhandledServerExceptionDisplaysStackTraceFor400SNICheck() throws Exception {
        this.props.setProperty("suppress.stack.trace.response", "false");
        this.startHttpServer("https");
        this.startHttpClient("https");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/test/path").accept(new String[]{"text/html"}).header("Host", "abc.com").send();
        String responseValue = response.getContentAsString();
        Assertions.assertEquals((int)400, (int)response.getStatus());
        Assertions.assertTrue((boolean)responseValue.toLowerCase().contains("host does not match sni"));
        Assertions.assertTrue((boolean)responseValue.toLowerCase().contains("caused by"));
    }

    @Test
    public void test_http_handledServerExceptionDoesNotDisplayStackTraceForInvalidAuthentication() throws Exception {
        this.startHttpServer("http");
        this.startHttpClient("http");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/test/path").accept(new String[]{"text/html"}).send();
        String responseValue = response.getContentAsString().toLowerCase();
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertFalse((boolean)responseValue.contains(DUMMY_EXCEPTION));
        Assertions.assertFalse((boolean)responseValue.contains("caused by"));
        Assertions.assertTrue((boolean)responseValue.contains("server error"));
    }

    @Test
    public void test_https_handledServerExceptionDoesNotDisplayStackTraceFor400SNICheck() throws Exception {
        this.startHttpServer("https");
        this.startHttpClient("https");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/test/path").accept(new String[]{"text/html"}).header("Host", "abc.com").send();
        String responseValue = response.getContentAsString();
        Assertions.assertEquals((int)400, (int)response.getStatus());
        Assertions.assertTrue((boolean)responseValue.toLowerCase().contains("host does not match sni"));
        Assertions.assertFalse((boolean)responseValue.toLowerCase().contains("caused by"));
    }

    private void startHttpClient(String scheme) throws Exception {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        if (scheme.equals("https")) {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            sslContextBuilder.loadKeyMaterial(new File(this.clientKeystore.getAbsolutePath()), SSL_PASSWORD.toCharArray(), SSL_PASSWORD.toCharArray());
            SSLContext sslContext = sslContextBuilder.build();
            SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setSNIProvider(SslContextFactory.Client.SniProvider.NON_DOMAIN_SNI_PROVIDER);
            sslContextFactory.setSslContext(sslContext);
            this.httpClient = new HttpClient((SslContextFactory)sslContextFactory);
        } else {
            this.httpClient = new HttpClient();
        }
        this.httpClient.start();
    }

    private void startHttpServer(String scheme) throws Exception {
        String url = scheme + "://localhost:" + TestUtils.getFreePort();
        this.props.setProperty("listeners", url);
        if (scheme.equals("https")) {
            File serverKeystore;
            File trustStore;
            try {
                trustStore = File.createTempFile("SslTest-truststore", ".jks");
                serverKeystore = File.createTempFile("SslTest-server-keystore", ".jks");
                this.clientKeystore = File.createTempFile("SslTest-client-keystore", ".jks");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create temporary files for trust stores and keystores.");
            }
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            this.createKeystoreWithCert(this.clientKeystore, "client", certs);
            this.createKeystoreWithCert(serverKeystore, "server", certs);
            TestSslUtils.createTrustStore((String)trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
            this.configServerKeystore(this.props, serverKeystore);
            this.configServerTruststore(this.props, trustStore);
        }
        TestApplication application = new TestApplication(TestRestConfig.maprCompatible(this.props));
        this.server = application.createServer();
        this.server.start();
    }

    private void configServerKeystore(Properties props, File serverKeystore) {
        props.put("ssl.keystore.location", serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
    }

    private void configServerTruststore(Properties props, File trustStore) {
        props.put("ssl.truststore.location", trustStore.getAbsolutePath());
        props.put("ssl.truststore.password", SSL_PASSWORD);
    }

    private void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"localhost"}).generate("CN=mymachine.localhost, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    @Path(value="/test")
    public static class TestResource {
        @GET
        @Path(value="/path")
        public String path() {
            return "Ok";
        }
    }

    private static class DummyLoginService
    extends AbstractLoginService {
        private DummyLoginService() {
        }

        protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
            return new String[0];
        }

        protected AbstractLoginService.UserPrincipal loadUserInfo(String username) {
            return null;
        }
    }

    private static class DummyAuthenticator
    extends BasicAuthenticator {
        private DummyAuthenticator() {
        }

        public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
            throw new RuntimeException(ErrorHandlerIntegrationTest.DUMMY_EXCEPTION);
        }
    }

    private static class TestApplication
    extends Application<TestRestConfig> {
        TestApplication(TestRestConfig restConfig) {
            super((RestConfig)restConfig);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(TestResource.class);
        }

        protected void configureSecurityHandler(ServletContextHandler context) {
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            Constraint constraint = new Constraint();
            constraint.setAuthenticate(true);
            String[] roles = new String[]{"**"};
            constraint.setRoles(roles);
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setConstraint(constraint);
            mapping.setMethod("*");
            mapping.setPathSpec("/*");
            securityHandler.addConstraintMapping(mapping);
            securityHandler.setAuthenticator((Authenticator)new DummyAuthenticator());
            securityHandler.setLoginService((LoginService)new DummyLoginService());
            context.setSecurityHandler((SecurityHandler)securityHandler);
        }
    }
}

