/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.mapr.test.MaprHomeSupport;
import io.confluent.rest.mapr.test.MaprTestLoginModule;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
public class SaslTest {
    private static final Logger log;
    private static final String NEHA_BASIC_AUTH = "bmVoYTpha2Zhaw==";
    private static final String JUN_BASIC_AUTH = "anVuOmthZmthLQ==";
    private static final String HTTP_URI = "http://localhost:8080";
    private static final String WS_URI = "ws://localhost:8080/ws";
    private static final Pattern WS_ERROR_PATTERN;
    private SaslTestApplication app;
    private CloseableHttpClient httpclient;

    @BeforeEach
    public void setUp() throws Exception {
        MaprTestLoginModule.restrict("jay", actualPassword -> actualPassword.equals("kafka"));
        MaprTestLoginModule.restrict("neha", actualPassword -> actualPassword.equals("akfak"));
        MaprTestLoginModule.restrict("jun", actualPassword -> actualPassword.equals("another-password"));
        this.httpclient = HttpClients.createDefault();
        TestMetricsReporter.reset();
        Properties props = new Properties();
        props.put("listeners", HTTP_URI);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        this.configAuthentication(props);
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        this.app = new SaslTestApplication(config);
        this.app.start();
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.assertMetricsCollected();
        this.httpclient.close();
        this.app.stop();
    }

    private void configAuthentication(Properties props) {
        props.put("authentication.enable", (Object)true);
        props.put("authentication.realm", "c3");
        props.put("authentication.roles", Collections.singletonList("Administrators"));
    }

    @Test
    public void testNoAuthAttempt() throws Exception {
        try (CloseableHttpResponse response = this.makeGetRequest("/test");){
            Assertions.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testNoAuthAttemptOnWs() throws Exception {
        int statusCode = this.makeWsGetRequest(null);
        Assertions.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)statusCode);
    }

    @Test
    public void testBadLoginAttempt() throws Exception {
        try (CloseableHttpResponse response = this.makeGetRequest("/test", "dGVzdA==");){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testBadLoginAttemptOnWs() throws Exception {
        int statusCode = this.makeWsGetRequest("dGVzdA==");
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)statusCode);
    }

    @Test
    public void testAuthorizedAttempt() throws Exception {
        try (CloseableHttpResponse response = this.makeGetRequest("/principal", NEHA_BASIC_AUTH);){
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            Assertions.assertEquals((Object)"neha", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        response = this.makeGetRequest("/role/Administrators", NEHA_BASIC_AUTH);
        try {
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            Assertions.assertEquals((Object)"false", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.makeGetRequest("/role/blah", NEHA_BASIC_AUTH);
        try {
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            Assertions.assertEquals((Object)"false", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testAuthorizedAttemptOnWs() throws Exception {
        int statusCode = this.makeWsGetRequest(NEHA_BASIC_AUTH);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)statusCode);
    }

    @Test
    public void testUnauthorizedAttempt() throws Exception {
        try (CloseableHttpResponse response = this.makeGetRequest("/principal", JUN_BASIC_AUTH);){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testUnAuthorizedAttemptOnWs() throws Exception {
        int statusCode = this.makeWsGetRequest(JUN_BASIC_AUTH);
        Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)statusCode);
    }

    private void assertMetricsCollected() {
        Assertions.assertNotEquals((int)0, (int)TestMetricsReporter.getMetricTimeseries().size(), (String)"Expected to have metrics.");
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().name().equals("request-latency-max")) continue;
            Object metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Request latency metrics should be measurable");
            double latencyMaxValue = (Double)metricValue;
            Assertions.assertNotEquals((Object)0.0, (Object)metricValue, (String)"Metrics should be collected (max latency shouldn't be 0)");
        }
    }

    private CloseableHttpResponse makeGetRequest(String url, String basicAuth) throws Exception {
        log.debug("Making GET http://localhost:8080" + url);
        HttpGet httpget = new HttpGet(HTTP_URI + url);
        if (basicAuth != null) {
            httpget.setHeader("Authorization", "Basic " + basicAuth);
        }
        return this.httpclient.execute((HttpUriRequest)httpget);
    }

    private CloseableHttpResponse makeGetRequest(String url) throws Exception {
        return this.makeGetRequest(url, null);
    }

    private int makeWsGetRequest(String basicAuth) throws Exception {
        log.debug("Making WebSocket GET ws://localhost:8080/ws/test");
        final AtomicReference error = new AtomicReference();
        WebSocketUpgradeHandler wsHandler = new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

            public void onOpen(WebSocket websocket) {
            }

            public void onClose(WebSocket websocket, int code, String reason) {
            }

            public void onError(Throwable t) {
                log.info("Websocket failed", t);
                error.set(t);
            }
        }).build();
        BoundRequestBuilder requestBuilder = Dsl.asyncHttpClient().prepareGet("ws://localhost:8080/ws/test");
        if (basicAuth != null) {
            requestBuilder = (BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Authorization", "Basic " + basicAuth);
        }
        WebSocket ws = (WebSocket)((BoundRequestBuilder)requestBuilder.setRequestTimeout(10000)).execute((AsyncHandler)wsHandler).get();
        if (error.get() != null) {
            return SaslTest.extractStatusCode(((Throwable)error.get()).getMessage());
        }
        ws.sendCloseFrame();
        return Response.Status.OK.getStatusCode();
    }

    private static int extractStatusCode(String message) {
        Matcher matcher = WS_ERROR_PATTERN.matcher(message);
        Assertions.assertTrue((boolean)matcher.matches(), (String)"Test invalid");
        return Integer.parseInt(matcher.group(1));
    }

    static {
        MaprHomeSupport.activate();
        log = LoggerFactory.getLogger(SaslTest.class);
        WS_ERROR_PATTERN = Pattern.compile(".*code=(\\d+).*");
    }

    @ServerEndpoint(value="/test")
    public static class WSEndpoint {
        @OnOpen
        public void onOpen(Session session, EndpointConfig endpointConfig) {
            session.getAsyncRemote().sendText("Test message", result -> {
                if (!result.isOK()) {
                    log.warn("Error sending websocket message for session {}", (Object)session.getId(), (Object)result.getException());
                }
            });
        }
    }

    @Path(value="/")
    @Produces(value={"text/plain"})
    public static class SaslTestResource {
        @GET
        @Path(value="/principal")
        @PerformanceMetric(value="principal")
        public String principal(@Context SecurityContext context) {
            return context.getUserPrincipal().getName();
        }

        @GET
        @Path(value="/role/{role}")
        @PerformanceMetric(value="role")
        public boolean hello(@PathParam(value="role") String role, @Context SecurityContext context) {
            return context.isUserInRole(role);
        }
    }

    private static class SaslTestApplication
    extends Application<TestRestConfig> {
        private SaslTestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new SaslTestResource());
        }

        protected void registerWebSocketEndpoints(ServerContainer container) {
            try {
                container.addEndpoint(ServerEndpointConfig.Builder.create(WSEndpoint.class, (String)WSEndpoint.class.getAnnotation(ServerEndpoint.class).value()).build());
            }
            catch (DeploymentException e) {
                Assertions.fail((String)"Invalid test");
            }
        }

        public Map<String, String> getMetricsTags() {
            return Collections.singletonMap("instance-id", "1");
        }
    }
}

