/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CustomMethodsTest {
    private TestRestConfig config;
    private Server server;

    @BeforeEach
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("listeners", "http://localhost:0");
        this.config = TestRestConfig.maprCompatible(props);
        CustomMethodsApplication application = new CustomMethodsApplication(this.config);
        this.server = application.createServer();
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testBaseCall() {
        Response response = ClientBuilder.newClient().target(this.server.getURI()).path("/foo/v2/collection/pants").request().get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        String responseBody = (String)response.readEntity(String.class);
        Assertions.assertEquals((Object)"base pants", (Object)responseBody);
    }

    @Test
    public void testIncorrectBaseCall() {
        Response response = ClientBuilder.newClient().target(this.server.getURI()).path("/foo/v2/collection/pants:search").request().get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        String responseBody = (String)response.readEntity(String.class);
        Assertions.assertEquals((Object)"custom pants", (Object)responseBody);
    }

    @Test
    public void testCustomMethodCall() {
        String[] tests;
        for (String test : tests = new String[]{"pants", "shoes", "pants-shoes", "pants:shoes", "pants:search", "pants:search:search", ":::::search"}) {
            Response response = ClientBuilder.newClient().target(this.server.getURI()).path("/foo/v2/collection/" + test + ":search").request().get();
            Assertions.assertEquals((int)200, (int)response.getStatus());
            String responseBody = (String)response.readEntity(String.class);
            String expected = "custom " + test;
            System.out.println("Expected='" + expected + "', actual='" + responseBody + "'");
            Assertions.assertEquals((Object)expected, (Object)responseBody);
        }
    }

    @Test
    public void testCustomMethodCallWithUrlEncodedId() {
        String[][] tests;
        for (String[] testCase : tests = new String[][]{{"pants%3Ashoes", "custom pants:shoes"}, {"pants%3Asearch", "custom pants:search"}}) {
            String test = testCase[0];
            String expected = testCase[1];
            Response response = ClientBuilder.newClient().target(this.server.getURI()).path("/foo/v2/collection/" + test + ":search").request().get();
            Assertions.assertEquals((int)200, (int)response.getStatus());
            String responseBody = (String)response.readEntity(String.class);
            System.out.println("Expected='" + expected + "', actual='" + responseBody + "'");
            Assertions.assertEquals((Object)expected, (Object)responseBody);
        }
    }

    @Produces(value={"application/octet-stream"})
    @Path(value="/foo")
    public static class CustomMethodsResource {
        @GET
        @Path(value="/v2/collection/{id}")
        public String baseEndpoint(@PathParam(value="id") String id) {
            return "base " + id;
        }

        @GET
        @Path(value="/v2/collection/{id}:search")
        public String customMethodEndpoint(@PathParam(value="id") String id) {
            return "custom " + id;
        }
    }

    private static class CustomMethodsApplication
    extends Application<TestRestConfig> {
        CustomMethodsApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(CustomMethodsResource.class);
        }
    }
}

