/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CsrfHandlingTest {
    TestRestConfig config;
    CsrfApplication app;
    private Server server;

    @BeforeEach
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("csrf.prevention.enable", "true");
        props.setProperty("suppress.stack.trace.response", "false");
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new CsrfApplication(this.config);
        this.server = this.app.createServer();
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testRequestWithValidToken() {
        String requestedBy = "user-session-1";
        String token = this.getToken(requestedBy);
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("ping").request().header("X-Requested-By", (Object)requestedBy).header("X-Requested-With", (Object)token).method("POST");
        String content = (String)response.readEntity(String.class);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"pong", (Object)content);
    }

    @Test
    public void testRequestMissingCsrfTokenException() {
        String requestedBy = "user-session-1";
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("ping").request().header("X-Requested-By", (Object)requestedBy).method("POST");
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Missing CSRF token in request header X-Requested-With"));
    }

    @Test
    public void testRequestMissingRequesterException() {
        String requestedBy = "user-session-1";
        String token = this.getToken(requestedBy);
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("ping").request().header("X-Requested-With", (Object)token).method("POST");
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Missing user session identifier in request header X-Requested-By"));
    }

    @Test
    public void testRequestInvalidCsrfTokenException() {
        String requestedBy = "user-session-1";
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("ping").request().header("X-Requested-By", (Object)requestedBy).header("X-Requested-With", (Object)"invalid token").method("POST");
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Invalid CSRF token in request header X-Requested-With"));
    }

    @Test
    public void testGetByPassesCheck() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("ping").request().get();
        String content = (String)response.readEntity(String.class);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"pong", (Object)content);
    }

    @Test
    public void testCsrfTokenFetchRequest() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/csrf").request().header("X-Requested-By", (Object)"test-session").get();
        String header = response.getHeaderString("X-CONFLUENT-CSRF-TOKEN");
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertNotNull((Object)header);
    }

    @Test
    public void testCsrfTokenFetchMissingRequester() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/csrf").request().get();
        String header = response.getHeaderString("X-CONFLUENT-CSRF-TOKEN");
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertNull((Object)header);
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Missing user session identifier in request header X-Requested-By"));
    }

    private String getToken(String requestedBy) {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/csrf").request().header("X-Requested-By", (Object)requestedBy).get();
        return response.getHeaderString("X-CONFLUENT-CSRF-TOKEN");
    }

    @Path(value="/")
    public static class TestResource {
        @GET
        @Path(value="/ping")
        public String getPing() {
            return "pong";
        }

        @POST
        @Path(value="/ping")
        public String postPing() {
            return "pong";
        }
    }

    private static class CsrfApplication
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        CsrfApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(TestResource.class);
        }
    }
}

