/**
 * Copyright 2019 Confluent Inc.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at</p>
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0</p>
 *
 * <p>Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.</p>
 */

package io.confluent.rest.util;

import io.confluent.rest.RestConfig;
import org.apache.commons.io.FileUtils;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class HeadersFilter  implements Filter {

  private Properties headerProperties = new Properties();

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
    String headersFilename = filterConfig.getInitParameter(RestConfig.HEADERS_FILE_CONFIG);
    File headerFile = new File(headersFilename);
    try {
      headerProperties.loadFromXML(FileUtils.openInputStream(headerFile));
    } catch (IOException e) {
      throw new ServletException(e);
    }
  }

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,
                       FilterChain filterChain) throws IOException, ServletException {
    HttpServletResponse httpServletResponse = (HttpServletResponse) servletResponse;
    headerProperties.forEach((k, v) -> {
      httpServletResponse.addHeader((String) k, v.toString());
    });

    // pass the request along the filter chain
    filterChain.doFilter(servletRequest, servletResponse);
  }

  @Override
  public void destroy() { }
}
