/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GzipHandlerIntegrationTest {
    TestRestConfig config;
    CompressibleApplication app;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        props.setProperty("compression.enable", "true");
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new CompressibleApplication(this.config);
        this.app.start();
    }

    @After
    public void tearDown() throws Exception {
        this.app.stop();
        this.app.join();
    }

    @Test
    public void testGzip() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path("/test/zeros").request(new String[]{"application/octet-stream"}).acceptEncoding(new String[]{"gzip"}).get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"gzip", (Object)response.getHeaderString("Content-Encoding"));
    }

    @Produces(value={"application/octet-stream"})
    @Path(value="/test")
    public static class ZerosResource {
        @GET
        @Path(value="/zeros")
        public byte[] zeros() {
            return new byte[0x100000];
        }
    }

    private static class CompressibleApplication
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        CompressibleApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(ZerosResource.class);
        }
    }
}

