/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.common.utils.IntegrationTest;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class RequestScopedMetricsIntegrationTest {
    TestRestConfig config;
    SimpleApplication app;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new SimpleApplication(this.config);
        this.app.start();
    }

    @After
    public void tearDown() throws Exception {
        this.app.stop();
        this.app.join();
    }

    @Test
    @Category(value={IntegrationTest.class})
    public void testRequestScopedMetricsCreateAndLookup() throws InterruptedException {
        int numMetrics = this.app.numMetrics();
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path("/public/ts").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Thread.sleep(500L);
        Assert.assertTrue((String)("numMetrics=" + numMetrics + ", app.numMetrics=" + this.app.numMetrics()), (numMetrics < this.app.numMetrics() ? 1 : 0) != 0);
        numMetrics = this.app.numMetrics();
        response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path("/public/ts").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((String)("numMetrics=" + numMetrics + ", app.numMetrics=" + this.app.numMetrics()), (long)numMetrics, (long)this.app.numMetrics());
    }

    public class Filter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext context) {
            HashMap<String, String> maps = new HashMap<String, String>();
            maps.put("runtime_tag-1", "runtime_value-1");
            context.setProperty("_request_tags", maps);
        }
    }

    @Produces(value={"application/json"})
    @Path(value="/public")
    public static class TimestampResource {
        @GET
        @Path(value="/ts")
        @PerformanceMetric(value="public.ts")
        public Long ts() {
            return System.currentTimeMillis();
        }
    }

    public class SimpleApplication
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        public SimpleApplication(TestRestConfig config) {
            super((RestConfig)config);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(TimestampResource.class);
            config.register((Object)new Filter());
        }

        public int numMetrics() {
            return this.getMetrics().metrics().size();
        }
    }
}

