/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.io.File;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApiHeadersTest {
    private static final String httpUri = "http://localhost:8080";
    private static final String httpsUri = "https://localhost:8081";
    private static final String SSL_PASSWORD = "test1234";
    private static String clientKeystoreLocation;
    private static TestApplication app;

    @BeforeClass
    public static void setUp() throws Exception {
        File trustStore = File.createTempFile("ApiHeadersTest-truststore", ".jks");
        File clientKeystore = File.createTempFile("ApiHeadersTest-client-keystore", ".jks");
        File serverKeystore = File.createTempFile("ApiHeadersTest-server-keystore", ".jks");
        clientKeystoreLocation = clientKeystore.getAbsolutePath();
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        ApiHeadersTest.createKeystoreWithCert(clientKeystore, "client", certs);
        ApiHeadersTest.createKeystoreWithCert(serverKeystore, "server", certs);
        TestSslUtils.createTrustStore((String)trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
        Properties props = new Properties();
        props.put("listeners", "http://localhost:8080,https://localhost:8081");
        props.put("ssl.keystore.location", serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
        app = new TestApplication(TestRestConfig.maprCompatible(props));
        app.start();
    }

    @AfterClass
    public static void teardown() throws Exception {
        if (app != null) {
            app.stop();
        }
    }

    @Test
    public void testHttpDoesNotReturnJettyServerVersionHeader() throws Exception {
        HttpGet httpget = new HttpGet("http://localhost:8080/test/endpoint");
        try (CloseableHttpClient httpclient = HttpClients.createDefault();
             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
            MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getFirstHeader("Server"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void testHttpsDoesNotReturnJettyServerVersionHeader() throws Exception {
        HttpGet httpget = new HttpGet("https://localhost:8081/test/endpoint");
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(new File(clientKeystoreLocation), SSL_PASSWORD.toCharArray(), SSL_PASSWORD.toCharArray()).build();
        SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
            MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getFirstHeader("Server"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    private static void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        X509Certificate cert = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA").sanDnsName("localhost").generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cert);
        certs.put(alias, cert);
    }

    @Path(value="/test/")
    @Produces(value={"application/json"})
    public static class TestResource {
        @GET
        @Path(value="/endpoint")
        public boolean test() {
            return true;
        }
    }

    private static class TestApplication
    extends Application<TestRestConfig> {
        public TestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new TestResource());
        }
    }
}

