/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestCustomizeThreadPool;
import io.confluent.rest.TestRestConfig;
import java.util.Arrays;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Enclosed.class)
public class TestCustomizedHttpResponseHeaders {
    private static final Logger log = LoggerFactory.getLogger(TestCustomizeThreadPool.class);

    private static CloseableHttpResponse makeGetRequest(TestApp app, String path) throws Exception {
        String uri = app.getUri();
        HttpGet httpget = new HttpGet(uri + path);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private static CloseableHttpResponse makePostRequest(TestApp app, String path) throws Exception {
        String uri = app.getUri();
        HttpPost httpPost = new HttpPost(uri + path);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private static String getResponseHeader(CloseableHttpResponse response, String name) {
        String value = null;
        Header[] headers = response.getAllHeaders();
        if (headers != null && headers.length > 0) {
            Arrays.stream(headers).forEach(header -> log.debug("header name: {}, header value: {}.", (Object)header.getName(), (Object)header.getValue()));
        }
        if ((headers = response.getHeaders(name)) != null && headers.length > 0) {
            value = headers[0].getValue();
        }
        return value;
    }

    private static class TestApp
    extends Application<TestRestConfig> {
        static Properties props = null;

        public TestApp() {
            super((RestConfig)TestApp.createConfig());
        }

        public TestApp(Properties props) {
            super((RestConfig)TestRestConfig.maprCompatible(props));
            TestApp.props = props;
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new RestResource());
        }

        public String getUri() {
            return (String)props.get("listeners");
        }

        private static TestRestConfig createConfig() {
            props = new Properties();
            String uri = "http://localhost:8080";
            return TestRestConfig.maprCompatible(props);
        }

        @Path(value="/custom")
        @Produces(value={"text/plain"})
        public static class RestResource {
            @GET
            @Path(value="/resource1")
            public String get1() {
                return "testing resource1";
            }

            @POST
            @Path(value="/resource2")
            public String get2() {
                return "testing resource2";
            }
        }
    }

    public static class TestValidHeaderConfig {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testNoCustomizedHeaderConfigs() throws Exception {
            Properties props = new Properties();
            props.put("listeners", "http://localhost:8080");
            TestApp app = new TestApp(props);
            CloseableHttpResponse response = null;
            try {
                app.start();
                response = TestCustomizedHttpResponseHeaders.makePostRequest(app, "/custom/resource2");
                String headerValue = TestCustomizedHttpResponseHeaders.getResponseHeader(response, "X-Frame-Options");
                Assert.assertNull((Object)headerValue);
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (Exception exception) {}
                app.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testValidHeaderConfigs() throws Exception {
            Properties props = new Properties();
            props.put("listeners", "http://localhost:8080");
            props.put("response.http.headers.config", "  set    X-Frame-Options: DENY, \"  add     Cache-Control:   no-cache, no-store, must-revalidate\" ");
            TestApp app = new TestApp(props);
            CloseableHttpResponse response = null;
            try {
                app.start();
                response = TestCustomizedHttpResponseHeaders.makeGetRequest(app, "/custom/resource1");
                Assert.assertEquals((Object)"DENY", (Object)TestCustomizedHttpResponseHeaders.getResponseHeader(response, "X-Frame-Options"));
                Assert.assertEquals((Object)"no-cache, no-store, must-revalidate", (Object)TestCustomizedHttpResponseHeaders.getResponseHeader(response, "Cache-Control"));
                Assert.assertNull((Object)TestCustomizedHttpResponseHeaders.getResponseHeader(response, "X-Custom-Value"));
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (Exception exception) {}
                app.stop();
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TestInvalidHeaderConfig {
        @Parameterized.Parameter
        public String invalidHeaderConfig;

        @Parameterized.Parameters(name="{0}")
        public static Object[] invalidData() {
            return new Object[]{"set", "badaction X-Frame-Options:DENY", "set add X-XSS-Protection:1", "addX-XSS-Protection", "X-XSS-Protection:", "add set X-XSS-Protection:", "add X-XSS-Protection:1 X-XSS-Protection:1 ", "add X-XSS-Protection:1,   ,", "set X-Frame-Options:DENY, add  :no-cache, no-store, must-revalidate "};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=ConfigException.class)
        public void testInvalidHeaderConfigFormat() throws Exception {
            Properties props = new Properties();
            props.put("listeners", "http://localhost:8080");
            props.put("response.http.headers.config", this.invalidHeaderConfig);
            TestApp app = new TestApp(props);
            CloseableHttpResponse response = null;
            try {
                app.start();
                response = TestCustomizedHttpResponseHeaders.makeGetRequest(app, "/custom/resource1");
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (Exception exception) {}
                app.stop();
            }
        }
    }
}

