/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jetty.http.HttpStatus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCustomizeThreadPool {
    private static final Logger log = LoggerFactory.getLogger(TestCustomizeThreadPool.class);
    private static Object locker = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testThreadPoolLessThreshold() throws Exception {
        int numOfClients = 3;
        TestCustomizeThreadPoolApplication app = new TestCustomizeThreadPoolApplication();
        String uri = app.getUri();
        try {
            app.start();
            this.makeConcurrentGetRequests(uri + "/custom/resource", numOfClients, app);
        }
        catch (Exception exception) {
            log.info("Current running thread {}, maximum thread {}.", (Object)app.getServer().getThreads(), (Object)app.getServer().getMaxThreads());
            Assert.assertTrue((String)("Total number of running threads is less than maximum number of threads " + app.getServer().getMaxThreads()), (app.getServer().getThreads() - app.getServer().getMaxThreads() < 0 ? 1 : 0) != 0);
            log.info("Total jobs in queue {}, capacity of queue {}.", (Object)app.getServer().getQueueSize(), (Object)app.getServer().getQueueCapacity());
            Assert.assertTrue((String)("Total number of jobs in queue is less than capacity of queue " + app.getServer().getQueueCapacity()), (app.getServer().getQueueSize() - app.getServer().getQueueCapacity() < 0 ? 1 : 0) != 0);
            app.stop();
            catch (Throwable throwable) {
                log.info("Current running thread {}, maximum thread {}.", (Object)app.getServer().getThreads(), (Object)app.getServer().getMaxThreads());
                Assert.assertTrue((String)("Total number of running threads is less than maximum number of threads " + app.getServer().getMaxThreads()), (app.getServer().getThreads() - app.getServer().getMaxThreads() < 0 ? 1 : 0) != 0);
                log.info("Total jobs in queue {}, capacity of queue {}.", (Object)app.getServer().getQueueSize(), (Object)app.getServer().getQueueCapacity());
                Assert.assertTrue((String)("Total number of jobs in queue is less than capacity of queue " + app.getServer().getQueueCapacity()), (app.getServer().getQueueSize() - app.getServer().getQueueCapacity() < 0 ? 1 : 0) != 0);
                app.stop();
                throw throwable;
            }
        }
        log.info("Current running thread {}, maximum thread {}.", (Object)app.getServer().getThreads(), (Object)app.getServer().getMaxThreads());
        Assert.assertTrue((String)("Total number of running threads is less than maximum number of threads " + app.getServer().getMaxThreads()), (app.getServer().getThreads() - app.getServer().getMaxThreads() < 0 ? 1 : 0) != 0);
        log.info("Total jobs in queue {}, capacity of queue {}.", (Object)app.getServer().getQueueSize(), (Object)app.getServer().getQueueCapacity());
        Assert.assertTrue((String)("Total number of jobs in queue is less than capacity of queue " + app.getServer().getQueueCapacity()), (app.getServer().getQueueSize() - app.getServer().getQueueCapacity() < 0 ? 1 : 0) != 0);
        app.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadPoolReachThreshold() throws Exception {
        int numOfClients = 40;
        TestCustomizeThreadPoolApplication app = new TestCustomizeThreadPoolApplication();
        String uri = app.getUri();
        try {
            app.start();
            this.makeConcurrentGetRequests(uri + "/custom/resource", numOfClients, app);
        }
        catch (Exception exception) {
        }
        finally {
            log.info("Current running thread {}, maximum thread {}.", (Object)app.getServer().getThreads(), (Object)app.getServer().getMaxThreads());
            Assert.assertEquals((String)"Total number of running threads reach maximum number of threads.", (long)app.getServer().getMaxThreads(), (long)app.getServer().getThreads());
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RejectedExecutionException.class)
    public void testQueueFull() throws Exception {
        int numOfClients = 1;
        Properties props = new Properties();
        props.put("listeners", "http://localhost:8080");
        props.put("thread.pool.min", "2");
        props.put("thread.pool.max", "10");
        props.put("request.queue.capacity.init", "0");
        props.put("request.queue.capacity", "0");
        props.put("request.queue.capacity.growby", "2");
        TestCustomizeThreadPoolApplication app = new TestCustomizeThreadPoolApplication(props);
        String uri = app.getUri();
        try {
            app.start();
            this.makeConcurrentGetRequests(uri + "/custom/resource", numOfClients, app);
        }
        finally {
            app.stop();
        }
    }

    private void makeConcurrentGetRequests(final String uri, int numThread, TestCustomizeThreadPoolApplication app) throws Exception {
        Thread[] threads = new Thread[numThread];
        for (int i = 0; i < numThread; ++i) {
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpGet httpget = new HttpGet(uri);
                    CloseableHttpClient httpclient = HttpClients.createDefault();
                    CloseableHttpResponse response = null;
                    try {
                        response = httpclient.execute((HttpUriRequest)httpget);
                        HttpStatus.Code statusCode = HttpStatus.getCode((int)response.getStatusLine().getStatusCode());
                        log.info("Status code {}, reason {} ", (Object)statusCode, (Object)response.getStatusLine().getReasonPhrase());
                        MatcherAssert.assertThat((Object)statusCode, (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            if (response != null) {
                                response.close();
                            }
                            httpclient.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            threads[i].start();
        }
        long startingTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startingTime < 360000L) {
            log.info("Queue size {}, queue capacity {} ", (Object)app.getServer().getQueueSize(), (Object)app.getServer().getQueueCapacity());
            Assert.assertTrue((String)"Number of jobs in queue is not more than capacity of queue ", (app.getServer().getQueueSize() <= app.getServer().getQueueCapacity() ? 1 : 0) != 0);
            Thread.sleep(2000L);
            if (app.getServer().getQueueSize() != 0) continue;
        }
        for (int i = 0; i < numThread; ++i) {
            threads[i].join();
        }
        log.info("End queue size {}, queue capacity {} ", (Object)app.getServer().getQueueSize(), (Object)app.getServer().getQueueCapacity());
    }

    private static class TestCustomizeThreadPoolApplication
    extends Application<TestRestConfig> {
        static Properties props = null;

        public TestCustomizeThreadPoolApplication() {
            super((RestConfig)TestCustomizeThreadPoolApplication.createConfig());
        }

        public TestCustomizeThreadPoolApplication(Properties props) {
            super((RestConfig)TestRestConfig.maprCompatible(props));
            TestCustomizeThreadPoolApplication.props = props;
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new RestResource());
        }

        public String getUri() {
            return (String)props.get("listeners");
        }

        private static TestRestConfig createConfig() {
            props = new Properties();
            String uri = "http://localhost:8080";
            props.put("listeners", uri);
            props.put("thread.pool.min", "2");
            props.put("thread.pool.max", "10");
            props.put("request.queue.capacity.init", "2");
            props.put("request.queue.capacity", "8");
            props.put("request.queue.capacity.growby", "2");
            return TestRestConfig.maprCompatible(props);
        }
    }

    @Path(value="/custom")
    @Produces(value={"text/plain"})
    public static class RestResource {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GET
        @Path(value="/resource")
        public String get() {
            Object object = locker;
            synchronized (object) {
                try {
                    locker.wait(10000L);
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                }
            }
            return "ThreadPool";
        }
    }
}

