/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.mapr.test;

import io.confluent.common.utils.TestUtils;
import io.confluent.rest.mapr.test.MaprHomeSupport;
import io.confluent.rest.mapr.test.MaprTestLoginModule;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.rules.ExternalResource;

public class MaprTestLoginRule
extends ExternalResource {
    private static final String JPAM_LOGIN = "jpamLogin";
    private final List<String> realms;
    private String previousAuthConfig;

    public MaprTestLoginRule(String ... realms) {
        this.realms = Arrays.asList(realms);
    }

    public static MaprTestLoginRule forHadoopSimpleAndJpam() {
        return new MaprTestLoginRule("hadoop_simple", JPAM_LOGIN);
    }

    protected void before() throws Throwable {
        File directory = MaprHomeSupport.isActive() ? MaprHomeSupport.MAPR_HOME_FOLDER : TestUtils.tempDirectory();
        File jaasFile = new File(directory, "/conf/jaas.conf");
        String jaas = this.realms.stream().map(this::configSectionForRealm).collect(Collectors.joining());
        FileUtils.write((File)jaasFile, (CharSequence)jaas, (Charset)StandardCharsets.UTF_8);
        this.previousAuthConfig = System.getProperty("java.security.auth.login.config");
        javax.security.auth.login.Configuration.setConfiguration(null);
        System.setProperty("java.security.auth.login.config", jaasFile.getAbsolutePath());
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    private String configSectionForRealm(String realm) {
        return realm + " {\n  " + MaprTestLoginModule.class.getName() + " required;\n};\n";
    }

    protected void after() {
        UserGroupInformation.reset();
        MaprTestLoginModule.reset();
        javax.security.auth.login.Configuration.setConfiguration(null);
        if (this.previousAuthConfig != null) {
            System.setProperty("java.security.auth.login.config", this.previousAuthConfig);
        }
    }
}

