/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsResourceMethodApplicationListenerIntegrationTest {
    TestRestConfig config;
    ApplicationWithFilter app;
    volatile Throwable handledException = null;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new ApplicationWithFilter(this.config);
        this.app.start();
    }

    @After
    public void tearDown() throws Exception {
        this.app.stop();
        this.app.join();
    }

    @Test
    public void testListenerHandlesDispatchErrorsGracefully() {
        Throwable cause;
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path("/private/endpoint").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertNotNull((Object)this.handledException);
        for (cause = this.handledException; !(cause instanceof ProcessingException) && cause != cause.getCause(); cause = cause.getCause()) {
        }
        Assert.assertTrue((boolean)(cause instanceof ProcessingException));
        Assert.assertEquals((Object)"Resource Java method invocation error.", (Object)cause.getMessage());
    }

    @Produces(value={"application/json"})
    @Path(value="/private")
    private static class PrivateResource {
        private PrivateResource() {
        }

        @GET
        @Path(value="/endpoint")
        public Void notAccessible() {
            return null;
        }
    }

    private class ApplicationWithFilter
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        ApplicationWithFilter(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(PrivateResource.class);
            config.property("jersey.config.server.response.setStatusOverSendError", (Object)true);
        }

        protected void configurePostResourceHandling(ServletContextHandler context) {
            context.setErrorHandler(new ErrorHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    MetricsResourceMethodApplicationListenerIntegrationTest.this.handledException = (Throwable)request.getAttribute("javax.servlet.error.exception");
                    super.handle(target, baseRequest, request, response);
                }
            });
        }
    }
}

