/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.auth;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.security.ConstraintMapping;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class AuthUtilTest {
    private RestConfig config;

    @Before
    public void setUp() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of());
    }

    @Test
    public void shouldDetectCorsBeingEnabled() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"access.control.allow.origin", (Object)"something"));
        MatcherAssert.assertThat((Object)AuthUtil.isCorsEnabled((RestConfig)this.config), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldDetectCorsDisabledWhenEmpty() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"access.control.allow.origin", (Object)""));
        MatcherAssert.assertThat((Object)AuthUtil.isCorsEnabled((RestConfig)this.config), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldCreateGlobalConstraintToCoverAllPaths() {
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getPathSpec(), (Matcher)CoreMatchers.is((Object)"/*"));
    }

    @Test
    public void shouldCreateGlobalConstraintToCoverAllMethods() {
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getMethod(), (Matcher)CoreMatchers.is((Object)"*"));
    }

    @Test
    public void shouldCreateGlobalConstraintWithNoMethodsOmittedForNonCor() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"access.control.allow.origin", (Object)""));
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getMethodOmissions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldCreateGlobalConstraintWithOptionsOmittedForCor() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"access.control.allow.origin", (Object)"something"));
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getMethodOmissions(), (Matcher)CoreMatchers.is((Object)new String[]{"OPTIONS"}));
    }

    @Test
    public void shouldCreateGlobalConstraintWithAuthRequired() {
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldDefaultToCreatingGlobalConstraintWithAnyRole() {
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getConstraint().isAnyRole(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)mapping.getConstraint().isAnyAuth(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)mapping.getConstraint().getRoles(), (Matcher)CoreMatchers.is((Object)new String[]{"*"}));
    }

    @Test
    public void shouldCreateGlobalConstraintWithRoles() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"authentication.roles", (Object)" r1 , r2 "));
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getConstraint().isAnyRole(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)mapping.getConstraint().getRoles(), (Matcher)CoreMatchers.is((Object)new String[]{"r1", "r2"}));
    }

    @Test
    public void shouldCreateGlobalConstraintWithNoRoles() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"authentication.roles", (Object)"*"));
        ConstraintMapping mapping = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mapping.getConstraint().isAnyRole(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)mapping.getConstraint().getRoles(), (Matcher)CoreMatchers.is((Object)new String[]{"*"}));
    }

    @Test
    public void shouldCreateNoUnsecuredPathConstraints() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"authentication.skip.paths", (Object)""));
        List mappings = AuthUtil.createUnsecuredConstraints((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mappings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldCreateUnsecuredPathConstraints() {
        this.config = AuthUtilTest.restConfigWith((Map<String, Object>)ImmutableMap.of((Object)"authentication.skip.paths", (Object)"/path/1,/path/2"));
        List mappings = AuthUtil.createUnsecuredConstraints((RestConfig)this.config);
        MatcherAssert.assertThat((Object)mappings.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getMethod(), (Matcher)CoreMatchers.is((Object)"*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/path/1"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getMethod(), (Matcher)CoreMatchers.is((Object)"*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/path/2"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static RestConfig restConfigWith(Map<String, Object> config) {
        return new RestConfig(RestConfig.baseConfigDef(), config);
    }
}

