/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.common.config.ConfigException;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.extension.ResourceExtension;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.security.Constraint;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ApplicationTest {
    private static final String REALM = "realm";
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private TestApp application;

    @Before
    public void setUp() {
        TestApp.SHUTDOWN_CALLED.set(false);
        TestRegistryExtension.CLOSE_CALLED.set(false);
    }

    @Before
    public void setup() throws Exception {
        this.application = new TestApp(new Class[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.application.stop();
    }

    @Test
    public void testParseListenersDeprecated() {
        ArrayList listenersConfig = new ArrayList();
        List listeners = Application.parseListeners(listenersConfig, (int)8080, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have only one listener.", (long)1L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "0.0.0.0", 8080);
    }

    @Test
    public void testParseListenersHttpAndHttps() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:123");
        listenersConfig.add("https://localhost:124");
        List listeners = TestApp.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have two listeners.", (long)2L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 123);
        this.assertExpectedUri((URI)listeners.get(1), "https", "localhost", 124);
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersUnparseableUri() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("!");
        Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test
    public void testParseListenersUnsupportedScheme() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:8080");
        listenersConfig.add("foo://localhost:8081");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have one listener.", (long)1L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 8080);
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersNoSupportedListeners() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("foo://localhost:8080");
        listenersConfig.add("bar://localhost:8081");
        Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersNoPort() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost");
        Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test
    public void testCreateSecurityHandlerWithNoRoles() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.realm", (Object)REALM, (Object)"authentication.roles", (Object)"");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        Assert.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assert.assertTrue((boolean)securityHandler.getRoles().isEmpty());
        Assert.assertNotNull((Object)securityHandler.getLoginService());
        Assert.assertNotNull((Object)securityHandler.getAuthenticator());
        Assert.assertEquals((long)1L, (long)securityHandler.getConstraintMappings().size());
        Assert.assertFalse((boolean)((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint().isAnyRole());
    }

    @Test
    public void testCreateSecurityHandlerWithAllRoles() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.realm", (Object)REALM, (Object)"authentication.roles", (Object)"*");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        Assert.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assert.assertTrue((boolean)securityHandler.getRoles().isEmpty());
        Assert.assertNotNull((Object)securityHandler.getLoginService());
        Assert.assertNotNull((Object)securityHandler.getAuthenticator());
        Assert.assertEquals((long)1L, (long)securityHandler.getConstraintMappings().size());
        Assert.assertTrue((boolean)((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint().isAnyRole());
    }

    @Test
    public void testCreateSecurityHandlerWithSpecificRoles() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.realm", (Object)REALM, (Object)"authentication.roles", (Object)"roleA, roleB");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        Assert.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assert.assertFalse((boolean)securityHandler.getRoles().isEmpty());
        Assert.assertNotNull((Object)securityHandler.getLoginService());
        Assert.assertNotNull((Object)securityHandler.getAuthenticator());
        Assert.assertEquals((long)1L, (long)securityHandler.getConstraintMappings().size());
        Constraint constraint = ((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint();
        Assert.assertFalse((boolean)constraint.isAnyRole());
        Assert.assertEquals((long)constraint.getRoles().length, (long)2L);
        Assert.assertArrayEquals((Object[])constraint.getRoles(), (Object[])new String[]{"roleA", "roleB"});
    }

    @Test
    public void testSetUnsecurePathConstraintsWithUnSecure() {
        ImmutableMap config = ImmutableMap.of((Object)"authentication.skip.paths", (Object)"/path/1,/path/2");
        ConstraintSecurityHandler securityHandler = new TestApp((Map<String, Object>)config).createBasicSecurityHandler();
        List mappings = securityHandler.getConstraintMappings();
        MatcherAssert.assertThat((Object)mappings.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/*"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(0)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/path/1"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(1)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(2)).getPathSpec(), (Matcher)CoreMatchers.is((Object)"/path/2"));
        MatcherAssert.assertThat((Object)((ConstraintMapping)mappings.get(2)).getConstraint().getAuthenticate(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldInitializeResourceExtensions() throws Exception {
        try (TestApp testApp = new TestApp(new Class[]{TestRegistryExtension.class});){
            MatcherAssert.assertThat((Object)this.makeGetRequest(testApp, "/custom/resource"), (Matcher)CoreMatchers.is((Object)HttpStatus.Code.OK));
        }
    }

    @Test
    public void shouldThrowIfResourceExtensionThrows() throws Exception {
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"Exception throw by resource extension. ext:"));
        new TestApp(new Class[]{TestRegistryExtension.class, BadRegistryExtension.class});
    }

    @Test
    public void shouldCloseResourceExtensions() throws Exception {
        new TestApp(new Class[]{TestRegistryExtension.class}).stop();
        MatcherAssert.assertThat((String)"close called", (Object)TestRegistryExtension.CLOSE_CALLED.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldShutdownProperlyEvenIfResourceExtensionThrowsOnShutdown() throws Exception {
        TestApp testApp = new TestApp(new Class[]{UnstoppableRegistryExtension.class});
        testApp.stop();
        testApp.join();
        MatcherAssert.assertThat((String)"shutdown called", (Object)TestApp.SHUTDOWN_CALLED.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertExpectedUri(URI uri, String scheme, String host, int port) {
        Assert.assertEquals((String)("Scheme should be " + scheme), (Object)scheme, (Object)uri.getScheme());
        Assert.assertEquals((String)("Host should be " + host), (Object)host, (Object)uri.getHost());
        Assert.assertEquals((String)("Port should be " + port), (long)port, (long)uri.getPort());
    }

    private HttpStatus.Code makeGetRequest(TestApp app, String path) throws Exception {
        HttpGet httpget = new HttpGet(((URL)app.getListeners().get(0)).toString() + path);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpStatus.Code code;
            block12: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                try {
                    code = HttpStatus.getCode((int)response.getStatusLine().getStatusCode());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return code;
        }
    }

    public static class UnstoppableRegistryExtension
    implements ResourceExtension<Application<?>> {
        public void register(Configurable<?> config, Application<?> app) {
        }

        public void close() throws IOException {
            throw new IOException("Boom");
        }
    }

    public static class BadRegistryExtension
    implements ResourceExtension<Application<?>> {
        public void register(Configurable<?> config, Application<?> app) {
            throw new IllegalArgumentException("Boom");
        }
    }

    public static class TestRegistryExtension
    implements ResourceExtension<TestApp> {
        private static final AtomicBoolean CLOSE_CALLED = new AtomicBoolean(true);

        public void register(Configurable<?> config, TestApp app) {
            TestRestConfig restConfig = (TestRestConfig)app.getConfiguration();
            Assert.assertNotNull((Object)((Object)restConfig));
            config.register((Object)new RestResource());
        }

        public void close() {
            CLOSE_CALLED.set(true);
        }
    }

    @Path(value="/custom")
    @Produces(value={"text/plain"})
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }
    }

    private static class TestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(true);

        @SafeVarargs
        private TestApp(Class<? extends ResourceExtension> ... extensions) throws Exception {
            super((RestConfig)TestApp.createConfig(extensions));
            this.start();
        }

        public TestApp(Map<String, Object> config) {
            super((RestConfig)TestApp.createConfig(config));
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public void onShutdown() {
            SHUTDOWN_CALLED.set(true);
        }

        private List<URL> getListeners() {
            return Arrays.stream(this.server.getConnectors()).filter(connector -> connector instanceof ServerConnector).map(ServerConnector.class::cast).map(connector -> {
                try {
                    String protocol = new HashSet(connector.getProtocols()).stream().map(String::toLowerCase).anyMatch(s -> s.equals("ssl")) ? "https" : "http";
                    int localPort = connector.getLocalPort();
                    return new URL(protocol, "localhost", localPort, "");
                }
                catch (Exception e) {
                    throw new RuntimeException("Malformed listener", e);
                }
            }).collect(Collectors.toList());
        }

        @SafeVarargs
        private static TestRestConfig createConfig(Class<? extends ResourceExtension> ... exts) {
            String extensionList = Arrays.stream(exts).map(Class::getName).collect(Collectors.joining(","));
            return TestApp.createConfig(Collections.singletonMap("resource.extension.classes", extensionList));
        }

        private static TestRestConfig createConfig(Map<String, Object> props) {
            HashMap<String, Object> config = new HashMap<String, Object>(props);
            config.put("listeners", "http://0.0.0.0:0");
            return TestRestConfig.maprCompatible(config);
        }
    }
}

