/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WebApplicationExceptionMapperTest {
    private WebApplicationExceptionMapper mapper;

    @Before
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        TestRestConfig config = new TestRestConfig(props);
        this.mapper = new WebApplicationExceptionMapper((RestConfig)config);
    }

    @Test
    public void testRestException() {
        Response response = this.mapper.toResponse((WebApplicationException)new RestException("msg", 400, 1000));
        Assert.assertEquals((long)400L, (long)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assert.assertEquals((Object)"msg", (Object)out.getMessage());
        Assert.assertEquals((long)1000L, (long)out.getErrorCode());
    }

    @Test
    public void testNonRestWebApplicationException() {
        Response response = this.mapper.toResponse(new WebApplicationException("msg", 400));
        Assert.assertEquals((long)400L, (long)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assert.assertEquals((Object)"msg", (Object)out.getMessage());
        Assert.assertEquals((long)400L, (long)out.getErrorCode());
    }
}

