/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.common.metrics.KafkaMetric;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslTest {
    private static final Logger log = LoggerFactory.getLogger(SslTest.class);
    private File trustStore;
    private File clientKeystore;
    private File serverKeystore;
    public static final String SSL_PASSWORD = "test1234";
    public static final String EXPECTED_200_MSG = "Response status must be 200.";

    @Before
    public void setUp() throws Exception {
        try {
            this.trustStore = File.createTempFile("SslTest-truststore", ".jks");
            this.clientKeystore = File.createTempFile("SslTest-client-keystore", ".jks");
            this.serverKeystore = File.createTempFile("SslTest-server-keystore", ".jks");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary files for trust stores and keystores.");
        }
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        this.createKeystoreWithCert(this.clientKeystore, "client", certs);
        this.createKeystoreWithCert(this.serverKeystore, "server", certs);
        TestSslUtils.createTrustStore((String)this.trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
    }

    private void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        X509Certificate cCert = TestSslUtils.generateCertificate((String)"CN=localhost, O=A client", (KeyPair)keypair, (int)30, (String)"SHA1withRSA");
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    private void configServerKeystore(Properties props) {
        props.put("ssl.keystore.location", this.serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
    }

    private void configServerTruststore(Properties props) {
        props.put("ssl.truststore.location", this.trustStore.getAbsolutePath());
        props.put("ssl.truststore.password", SSL_PASSWORD);
    }

    private void enableSslClientAuth(Properties props) {
        props.put("ssl.client.auth", (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SSLException.class)
    public void testHttpOnly() throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        String uri = "http://localhost:8080";
        props.put("listeners", uri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        TestRestConfig config = new TestRestConfig(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            app.start();
            int statusCode = this.makeGetRequest(uri + "/test");
            Assert.assertEquals((String)EXPECTED_200_MSG, (long)200L, (long)statusCode);
            this.assertMetricsCollected();
            this.makeGetRequest("https://localhost:8080/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
        }
        finally {
            app.stop();
        }
    }

    private void assertMetricsCollected() {
        Assert.assertNotEquals((String)"Expected to have metrics.", (long)0L, (long)TestMetricsReporter.getMetricTimeseries().size());
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().name().equals("request-latency-max")) continue;
            Assert.assertTrue((String)"Metrics should be collected (max latency shouldn't be 0)", (metric.value() != 0.0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeGetRequest(String url, String clientKeystoreLocation, String clientKeystorePassword, String clientKeyPassword) throws Exception {
        CloseableHttpClient httpclient;
        log.debug("Making GET " + url);
        HttpGet httpget = new HttpGet(url);
        if (url.startsWith("http://")) {
            httpclient = HttpClients.createDefault();
        } else {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            if (clientKeystoreLocation != null) {
                sslContextBuilder.loadKeyMaterial(new File(clientKeystoreLocation), clientKeystorePassword.toCharArray(), clientKeyPassword.toCharArray());
            }
            SSLContext sslContext = sslContextBuilder.build();
            SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
        }
        int statusCode = -1;
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            statusCode = response.getStatusLine().getStatusCode();
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        return statusCode;
    }

    private int makeGetRequest(String url) throws Exception {
        return this.makeGetRequest(url, null, null, null);
    }

    @Path(value="/test")
    @Produces(value={"application/test.v1+json"})
    public static class SslTestResource {
        @GET
        @PerformanceMetric(value="test")
        public SslTestResponse hello() {
            return new SslTestResponse();
        }

        public static class SslTestResponse {
            @JsonProperty
            public String getMessage() {
                return "foo";
            }
        }
    }

    private static class SslTestApplication
    extends Application<TestRestConfig> {
        public SslTestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new SslTestResource());
        }

        public Map<String, String> getMetricsTags() {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("instance-id", "1");
            return tags;
        }
    }
}

