/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTest {
    private static final Logger log = LoggerFactory.getLogger(ShutdownTest.class);

    @Test
    public void testShutdownHook() throws Exception {
        Properties props = new Properties();
        props.put("shutdown.graceful.ms", "50");
        ShutdownApplication app = new ShutdownApplication(new TestRestConfig(props));
        app.start();
        StopThread stop = new StopThread(app);
        stop.start();
        app.join();
        Assert.assertTrue((boolean)app.shutdown.get());
    }

    @Test
    public void testGracefulShutdown() throws Exception {
        Properties props = new Properties();
        props.put("shutdown.graceful.ms", "150");
        TestRestConfig config = new TestRestConfig(props);
        ShutdownApplication app = new ShutdownApplication(config);
        app.start();
        RequestThread req = new RequestThread(config);
        req.start();
        app.resource.requestProcessingStarted.await();
        StopThread stop = new StopThread(app);
        stop.start();
        app.join();
        log.info("Application finished");
        req.join(50L);
        Assert.assertTrue((boolean)req.finished);
        Assert.assertEquals((Object)"done", (Object)req.response);
    }

    private static class RequestThread
    extends Thread {
        RestConfig config;
        volatile boolean finished = false;
        String response = null;

        RequestThread(RestConfig config) {
            this.config = config;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    log.info("Starting client");
                    Client client = ClientBuilder.newClient();
                    this.response = (String)client.target("http://localhost:" + this.config.getInt("port")).path("/").request().get(String.class);
                    log.info("Marking request finished");
                    this.finished = true;
                    return;
                }
                catch (ProcessingException e) {
                    log.info("Request failed, will retry", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private static class StopThread
    extends Thread {
        ShutdownApplication app;

        StopThread(ShutdownApplication app) {
            this.app = app;
        }

        @Override
        public void run() {
            try {
                log.info("Requesting application stop");
                this.app.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Path(value="/")
    public static class SlowResource {
        public CountDownLatch requestProcessingStarted = new CountDownLatch(1);

        @GET
        public String test() throws InterruptedException {
            this.requestProcessingStarted.countDown();
            Thread.sleep(25L);
            return "done";
        }
    }

    private static class ShutdownApplication
    extends Application<TestRestConfig> {
        public AtomicBoolean shutdown = new AtomicBoolean(false);
        public SlowResource resource = new SlowResource();

        ShutdownApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void onShutdown() {
            this.shutdown.set(true);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)this.resource);
        }
    }
}

