/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.common.config.ConfigException;
import io.confluent.rest.Application;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jersey.repackaged.com.google.common.collect.Lists;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationTest {
    public static final String REALM = "realm";

    @Test
    public void testParseListenersDeprecated() {
        ArrayList listenersConfig = new ArrayList();
        List listeners = Application.parseListeners(listenersConfig, (int)8080, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have only one listener.", (long)1L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "0.0.0.0", 8080);
    }

    @Test
    public void testParseListenersHttpAndHttps() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:123");
        listenersConfig.add("https://localhost:124");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have two listeners.", (long)2L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 123);
        this.assertExpectedUri((URI)listeners.get(1), "https", "localhost", 124);
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersUnparseableUri() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("!");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test
    public void testParseListenersUnsupportedScheme() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:8080");
        listenersConfig.add("foo://localhost:8081");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have one listener.", (long)1L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 8080);
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersNoSupportedListeners() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("foo://localhost:8080");
        listenersConfig.add("bar://localhost:8081");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersNoPort() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test
    public void testAuthEnabledNONE() {
        Assert.assertFalse((boolean)Application.enableBasicAuth((String)"NONE"));
    }

    @Test
    public void testAuthEnabledBASIC() {
        Assert.assertTrue((boolean)Application.enableBasicAuth((String)"BASIC"));
    }

    public void testCreateSecurityHandlerWithNoRoles() {
        ConstraintSecurityHandler securityHandler = Application.createSecurityHandler((String)REALM, (List)Lists.newArrayList());
        Assert.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assert.assertTrue((boolean)securityHandler.getRoles().isEmpty());
        Assert.assertNotNull((Object)securityHandler.getLoginService());
        Assert.assertNotNull((Object)securityHandler.getAuthenticator());
        Assert.assertEquals((long)1L, (long)securityHandler.getConstraintMappings().size());
        Assert.assertFalse((boolean)((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint().isAnyRole());
    }

    public void testCreateSecurityHandlerWithAllRoles() {
        ConstraintSecurityHandler securityHandler = Application.createSecurityHandler((String)REALM, (List)Lists.newArrayList((Object[])new String[]{"*"}));
        Assert.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assert.assertTrue((boolean)securityHandler.getRoles().isEmpty());
        Assert.assertNotNull((Object)securityHandler.getLoginService());
        Assert.assertNotNull((Object)securityHandler.getAuthenticator());
        Assert.assertEquals((long)1L, (long)securityHandler.getConstraintMappings().size());
        Assert.assertTrue((boolean)((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint().isAnyRole());
    }

    public void testCreateSecurityHandlerWithSpecificRoles() {
        ArrayList roles = Lists.newArrayList((Object[])new String[]{"roleA", "roleB"});
        ConstraintSecurityHandler securityHandler = Application.createSecurityHandler((String)REALM, (List)roles);
        Assert.assertEquals((Object)securityHandler.getRealmName(), (Object)REALM);
        Assert.assertFalse((boolean)securityHandler.getRoles().isEmpty());
        Assert.assertNotNull((Object)securityHandler.getLoginService());
        Assert.assertNotNull((Object)securityHandler.getAuthenticator());
        Assert.assertEquals((long)1L, (long)securityHandler.getConstraintMappings().size());
        Constraint constraint = ((ConstraintMapping)securityHandler.getConstraintMappings().get(0)).getConstraint();
        Assert.assertFalse((boolean)constraint.isAnyRole());
        Assert.assertEquals((long)constraint.getRoles().length, (long)roles.size());
        Assert.assertArrayEquals((Object[])constraint.getRoles(), (Object[])roles.toArray(new String[roles.size()]));
    }

    private void assertExpectedUri(URI uri, String scheme, String host, int port) {
        Assert.assertEquals((String)("Scheme should be " + scheme), (Object)scheme, (Object)uri.getScheme());
        Assert.assertEquals((String)("Host should be " + host), (Object)host, (Object)uri.getHost());
        Assert.assertEquals((String)("Port should be " + port), (long)port, (long)uri.getPort());
    }
}

