/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.common.config.AbstractConfig;
import io.confluent.common.config.ConfigDef;
import io.confluent.common.utils.SystemTime;
import io.confluent.common.utils.Time;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RestConfig
extends AbstractConfig {
    public static final String DEBUG_CONFIG = "debug";
    protected static final String DEBUG_CONFIG_DOC = "Boolean indicating whether extra debugging information is generated in some error response entities.";
    protected static final boolean DEBUG_CONFIG_DEFAULT = false;
    public static final String PORT_CONFIG = "port";
    protected static final String PORT_CONFIG_DOC = "DEPRECATED: port to listen on for new HTTP connections. Use listeners instead.";
    protected static final int PORT_CONFIG_DEFAULT = 8080;
    public static final String LISTENERS_CONFIG = "listeners";
    protected static final String LISTENERS_DOC = "List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081";
    protected static final String LISTENERS_DEFAULT = "";
    public static final String RESPONSE_MEDIATYPE_PREFERRED_CONFIG = "response.mediatype.preferred";
    protected static final String RESPONSE_MEDIATYPE_PREFERRED_CONFIG_DOC = "An ordered list of the server's preferred media types used for responses, from most preferred to least.";
    protected static final String RESPONSE_MEDIATYPE_PREFERRED_CONFIG_DEFAULT = "application/json";
    public static final String RESPONSE_MEDIATYPE_DEFAULT_CONFIG = "response.mediatype.default";
    protected static final String RESPONSE_MEDIATYPE_DEFAULT_CONFIG_DOC = "The default response media type that should be used if no specify types are requested in an Accept header.";
    protected static final String RESPONSE_MEDIATYPE_DEFAULT_CONFIG_DEFAULT = "application/json";
    public static final String SHUTDOWN_GRACEFUL_MS_CONFIG = "shutdown.graceful.ms";
    protected static final String SHUTDOWN_GRACEFUL_MS_DOC = "Amount of time to wait after a shutdown request for outstanding requests to complete.";
    protected static final String SHUTDOWN_GRACEFUL_MS_DEFAULT = "1000";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG = "access.control.allow.origin";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DOC = "Set value for Jetty Access-Control-Allow-Origin header";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DEFAULT = "";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "access.control.allow.methods";
    protected static final String ACCESS_CONTROL_ALLOW_METHODS_DOC = "Set value to Jetty Access-Control-Allow-Origin header for specified methods";
    protected static final String ACCESS_CONTROL_ALLOW_METHODS_DEFAULT = "";
    public static final String REQUEST_LOGGER_NAME_CONFIG = "request.logger.name";
    protected static final String REQUEST_LOGGER_NAME_DOC = "Name of the SLF4J logger to write the NCSA Common Log Format request log.";
    protected static final String REQUEST_LOGGER_NAME_DEFAULT = "io.confluent.rest-utils.requests";
    public static final String METRICS_JMX_PREFIX_CONFIG = "metrics.jmx.prefix";
    protected static final String METRICS_JMX_PREFIX_DOC = "Prefix to apply to metric names for the default JMX reporter.";
    protected static final String METRICS_JMX_PREFIX_DEFAULT = "rest-utils";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    protected static final String METRICS_SAMPLE_WINDOW_MS_DOC = "The metrics system maintains a configurable number of samples over a fixed window size. This configuration controls the size of the window. For example we might maintain two samples each measured over a 30 second period. When a window expires we erase and overwrite the oldest window.";
    protected static final long METRICS_SAMPLE_WINDOW_MS_DEFAULT = 30000L;
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    protected static final String METRICS_NUM_SAMPLES_DOC = "The number of samples maintained to compute metrics.";
    protected static final int METRICS_NUM_SAMPLES_DEFAULT = 2;
    public static final String METRICS_REPORTER_CLASSES_CONFIG = "metric.reporters";
    protected static final String METRICS_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters. Implementing the <code>MetricReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.";
    protected static final String METRICS_REPORTER_CLASSES_DEFAULT = "";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "ssl.keystore.location";
    protected static final String SSL_KEYSTORE_LOCATION_DOC = "Location of the keystore file to use for SSL. This is required for HTTPS.";
    protected static final String SSL_KEYSTORE_LOCATION_DEFAULT = "";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "ssl.keystore.password";
    protected static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the keystore file.";
    protected static final String SSL_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String SSL_KEY_PASSWORD_CONFIG = "ssl.key.password";
    protected static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the keystore file.";
    protected static final String SSL_KEY_PASSWORD_DEFAULT = "";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "ssl.keystore.type";
    protected static final String SSL_KEYSTORE_TYPE_DOC = "The type of keystore file.";
    protected static final String SSL_KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String SSL_KEYMANAGER_ALGORITHM_CONFIG = "ssl.keymanager.algorithm";
    protected static final String SSL_KEYMANAGER_ALGORITHM_DOC = "The algorithm used by the key manager factory for SSL connections. Leave blank to use Jetty's default.";
    protected static final String SSL_KEYMANAGER_ALGORITHM_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "ssl.truststore.location";
    protected static final String SSL_TRUSTSTORE_LOCATION_DOC = "Location of the trust store. Required only to authenticate HTTPS clients.";
    protected static final String SSL_TRUSTSTORE_LOCATION_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "ssl.truststore.password";
    protected static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The store password for the trust store file.";
    protected static final String SSL_TRUSTSTORE_PASSWORD_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "ssl.truststore.type";
    protected static final String SSL_TRUSTSTORE_TYPE_DOC = "The type of trust store file.";
    protected static final String SSL_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    public static final String SSL_TRUSTMANAGER_ALGORITHM_CONFIG = "ssl.trustmanager.algorithm";
    protected static final String SSL_TRUSTMANAGER_ALGORITHM_DOC = "The algorithm used by the trust manager factory for SSL connections. Leave blank to use Jetty's default.";
    protected static final String SSL_TRUSTMANAGER_ALGORITHM_DEFAULT = "";
    public static final String SSL_PROTOCOL_CONFIG = "ssl.protocol";
    protected static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SslContextFactory.";
    protected static final String SSL_PROTOCOL_DEFAULT = "TLS";
    public static final String SSL_PROVIDER_CONFIG = "ssl.provider";
    protected static final String SSL_PROVIDER_DOC = "The SSL security provider name. Leave blank to use Jetty's default.";
    protected static final String SSL_PROVIDER_DEFAULT = "";
    public static final String SSL_CLIENT_AUTH_CONFIG = "ssl.client.auth";
    protected static final String SSL_CLIENT_AUTH_DOC = "Whether or not to require the https client to authenticate via the server's trust store.";
    protected static final boolean SSL_CLIENT_AUTH_DEFAULT = false;
    public static final String SSL_ENABLED_PROTOCOLS_CONFIG = "ssl.enabled.protocols";
    protected static final String SSL_ENABLED_PROTOCOLS_DOC = "The list of protocols enabled for SSL connections. Comma-separated list. Leave blank to use Jetty's defaults.";
    public static final String SSL_DISABLED_PROTOCOLS_CONFIG = "ssl.disabled.protocols";
    protected static final String SSL_DISABLED_PROTOCOLS_DOC = "The list of protocols disabled for SSL connections. Comma-separated list. Leave blank to use Jetty's defaults.";
    protected static final String SSL_DISABLED_PROTOCOLS_DEFAULT = "SSLv3, TLSv1.0";
    protected static final String SSL_ENABLED_PROTOCOLS_DEFAULT = "";
    public static final String SSL_CIPHER_SUITES_CONFIG = "ssl.cipher.suites";
    protected static final String SSL_CIPHER_SUITES_DOC = "A list of SSL cipher suites. Leave blank to use Jetty's defaults.";
    protected static final String SSL_CIPHER_SUITES_DEFAULT = "";
    public static final String SSL_DISABLED_CIPHER_SUITES_CONFIG = "ssl.cipher.suites.exclude";
    protected static final String SSL_DISABLED_CIPHER_SUITES_DOC = "A list of excluded SSL cipher suites. Leave blank to use Jetty's defaults.";
    protected static final String SSL_DISABLED_CIPHER_SUITES_DEFAULT = "TLS_DHE.*, TLS_EDH.*, .*RC4.*, .*MD5.*, .*DES.*";
    public static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG = "ssl.endpoint.identification.algorithm";
    protected static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DOC = "The endpoint identification algorithm to validate the server hostname using the server certificate. Leave blank to use Jetty's default.";
    protected static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DEFAULT = "";
    public static final String AUTHENTICATION_METHOD_CONFIG = "authentication.method";
    public static final String AUTHENTICATION_METHOD_NONE = "NONE";
    public static final String AUTHENTICATION_METHOD_BASIC = "BASIC";
    public static final String AUTHENTICATION_METHOD_DOC = "Method of authentication. Must be BASIC to enable authentication. You must supply a valid JAAS config file for the 'java.security.auth.login.config' system property for the appropriate authentication provider.";
    public static final ConfigDef.ValidString AUTHENTICATION_METHOD_VALIDATOR = ConfigDef.ValidString.in(Arrays.asList("NONE", "BASIC"));
    public static final String AUTHENTICATION_REALM_CONFIG = "authentication.realm";
    public static final String AUTHENTICATION_REALM_DOC = "Security realm to be used in authentication.";
    public static final String AUTHENTICATION_ROLES_CONFIG = "authentication.roles";
    public static final String AUTHENTICATION_ROLES_DOC = "Valid roles to authenticate against.";
    public static final List<String> AUTHENTICATION_ROLES_DEFAULT = Collections.unmodifiableList(Arrays.asList("*"));
    public static final String ENABLE_GZIP_COMPRESSION_CONFIG = "compression.enable";
    protected static final String ENABLE_GZIP_COMPRESSION_DOC = "Enable gzip compression";
    private static final boolean ENABLE_GZIP_COMPRESSION_DEFAULT = false;
    private static Time defaultTime = new SystemTime();

    public static ConfigDef baseConfigDef() {
        return new ConfigDef().define(DEBUG_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, DEBUG_CONFIG_DOC).define(PORT_CONFIG, ConfigDef.Type.INT, (Object)8080, ConfigDef.Importance.LOW, PORT_CONFIG_DOC).define(LISTENERS_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.HIGH, LISTENERS_DOC).define(RESPONSE_MEDIATYPE_PREFERRED_CONFIG, ConfigDef.Type.LIST, (Object)"application/json", ConfigDef.Importance.LOW, RESPONSE_MEDIATYPE_PREFERRED_CONFIG_DOC).define(RESPONSE_MEDIATYPE_DEFAULT_CONFIG, ConfigDef.Type.STRING, (Object)"application/json", ConfigDef.Importance.LOW, RESPONSE_MEDIATYPE_DEFAULT_CONFIG_DOC).define(SHUTDOWN_GRACEFUL_MS_CONFIG, ConfigDef.Type.INT, (Object)SHUTDOWN_GRACEFUL_MS_DEFAULT, ConfigDef.Importance.LOW, SHUTDOWN_GRACEFUL_MS_DOC).define(ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, ACCESS_CONTROL_ALLOW_ORIGIN_DOC).define(ACCESS_CONTROL_ALLOW_METHODS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, ACCESS_CONTROL_ALLOW_METHODS_DOC).define(REQUEST_LOGGER_NAME_CONFIG, ConfigDef.Type.STRING, (Object)REQUEST_LOGGER_NAME_DEFAULT, ConfigDef.Importance.LOW, REQUEST_LOGGER_NAME_DOC).define(METRICS_JMX_PREFIX_CONFIG, ConfigDef.Type.STRING, (Object)METRICS_JMX_PREFIX_DEFAULT, ConfigDef.Importance.LOW, METRICS_JMX_PREFIX_DOC).define(METRICS_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, METRICS_REPORTER_CLASSES_DOC).define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)30000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, METRICS_SAMPLE_WINDOW_MS_DOC).define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, METRICS_NUM_SAMPLES_DOC).define(SSL_KEYSTORE_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, SSL_KEYSTORE_LOCATION_DOC).define(SSL_KEYSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, SSL_KEYSTORE_PASSWORD_DOC).define(SSL_KEY_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, SSL_KEY_PASSWORD_DOC).define(SSL_KEYSTORE_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, SSL_KEYSTORE_TYPE_DOC).define(SSL_KEYMANAGER_ALGORITHM_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, SSL_KEYMANAGER_ALGORITHM_DOC).define(SSL_TRUSTSTORE_LOCATION_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, SSL_TRUSTSTORE_LOCATION_DOC).define(SSL_TRUSTSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, SSL_TRUSTSTORE_PASSWORD_DOC).define(SSL_TRUSTSTORE_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, SSL_TRUSTSTORE_TYPE_DOC).define(SSL_TRUSTMANAGER_ALGORITHM_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, SSL_TRUSTMANAGER_ALGORITHM_DOC).define(SSL_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, SSL_PROTOCOL_DOC).define(SSL_PROVIDER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, SSL_PROVIDER_DOC).define(SSL_CLIENT_AUTH_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, SSL_CLIENT_AUTH_DOC).define(SSL_ENABLED_PROTOCOLS_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, SSL_ENABLED_PROTOCOLS_DOC).define(SSL_DISABLED_PROTOCOLS_CONFIG, ConfigDef.Type.LIST, (Object)SSL_DISABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, SSL_DISABLED_PROTOCOLS_DOC).define(SSL_CIPHER_SUITES_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, SSL_CIPHER_SUITES_DOC).define(SSL_DISABLED_CIPHER_SUITES_CONFIG, ConfigDef.Type.LIST, (Object)SSL_DISABLED_CIPHER_SUITES_DEFAULT, ConfigDef.Importance.LOW, SSL_DISABLED_CIPHER_SUITES_DOC).define(SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DOC).define(AUTHENTICATION_METHOD_CONFIG, ConfigDef.Type.STRING, (Object)AUTHENTICATION_METHOD_NONE, (ConfigDef.Validator)AUTHENTICATION_METHOD_VALIDATOR, ConfigDef.Importance.LOW, AUTHENTICATION_METHOD_DOC).define(AUTHENTICATION_REALM_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, AUTHENTICATION_REALM_DOC).define(AUTHENTICATION_ROLES_CONFIG, ConfigDef.Type.LIST, AUTHENTICATION_ROLES_DEFAULT, ConfigDef.Importance.LOW, AUTHENTICATION_ROLES_DOC).define(ENABLE_GZIP_COMPRESSION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, ENABLE_GZIP_COMPRESSION_DOC);
    }

    public RestConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals);
    }

    public RestConfig(ConfigDef definition) {
        super(definition, new TreeMap());
    }

    public Time getTime() {
        return defaultTime;
    }
}

