/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.common.config.ConfigException;
import io.confluent.common.metrics.JmxReporter;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.Metrics;
import io.confluent.common.metrics.MetricsReporter;
import io.confluent.rest.MetricsListener;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.GenericExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import io.confluent.rest.logging.Slf4jRequestLog;
import io.confluent.rest.metrics.MetricsResourceMethodApplicationListener;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.AsyncGzipFilter;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application<T extends RestConfig> {
    protected T config;
    protected Server server = null;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected Metrics metrics;
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public Application(T config) {
        this.config = config;
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS);
        List reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter(config.getString("metrics.jmx.prefix")));
        this.metrics = new Metrics(metricConfig, reporters, ((RestConfig)((Object)config)).getTime());
    }

    public abstract void setupResources(Configurable<?> var1, T var2);

    protected ResourceCollection getStaticResources() {
        return null;
    }

    protected void configurePostResourceHandling(ServletContextHandler context) {
    }

    public Map<String, String> getMetricsTags() {
        return new LinkedHashMap<String, String>();
    }

    public Server createServer() throws RestConfigException {
        String allowedOrigins;
        String authMethod;
        ResourceConfig resourceConfig = new ResourceConfig();
        Map<String, String> metricTags = this.getMetricsTags();
        this.configureBaseApplication((Configurable<?>)resourceConfig, metricTags);
        this.setupResources((Configurable<?>)resourceConfig, this.getConfiguration());
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        FilterHolder servletHolder = new FilterHolder((Filter)servletContainer);
        this.server = new Server(){

            protected void doStop() throws Exception {
                super.doStop();
                Application.this.metrics.close();
                Application.this.onShutdown();
                Application.this.shutdownLatch.countDown();
            }
        };
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        MetricsListener metricsListener = new MetricsListener(this.metrics, "jetty", metricTags);
        List<URI> listeners = Application.parseListeners(this.config.getList("listeners"), this.config.getInt("port"), Arrays.asList("http", "https"), "http");
        for (URI listener : listeners) {
            NetworkTrafficServerConnector connector;
            log.info("Adding listener: " + listener.toString());
            if (listener.getScheme().equals("http")) {
                connector = new NetworkTrafficServerConnector(this.server);
            } else {
                List excludedCipherSuites;
                List cipherSuites;
                List disabledProtocols;
                SslContextFactory sslContextFactory = new SslContextFactory();
                if (!this.config.getString("ssl.keystore.location").isEmpty()) {
                    sslContextFactory.setKeyStorePath(this.config.getString("ssl.keystore.location"));
                    sslContextFactory.setKeyStorePassword(this.config.getPassword("ssl.keystore.password").value());
                    sslContextFactory.setKeyManagerPassword(this.config.getPassword("ssl.key.password").value());
                    sslContextFactory.setKeyStoreType(this.config.getString("ssl.keystore.type"));
                    if (!this.config.getString("ssl.keymanager.algorithm").isEmpty()) {
                        sslContextFactory.setSslKeyManagerFactoryAlgorithm(this.config.getString("ssl.keymanager.algorithm"));
                    }
                }
                sslContextFactory.setNeedClientAuth(this.config.getBoolean("ssl.client.auth"));
                List enabledProtocols = this.config.getList("ssl.enabled.protocols");
                if (!enabledProtocols.isEmpty()) {
                    sslContextFactory.setIncludeProtocols(enabledProtocols.toArray(new String[0]));
                }
                if (!(disabledProtocols = this.config.getList("ssl.disabled.protocols")).isEmpty()) {
                    sslContextFactory.setExcludeProtocols(disabledProtocols.toArray(new String[0]));
                }
                if (!(cipherSuites = this.config.getList("ssl.cipher.suites")).isEmpty()) {
                    sslContextFactory.setIncludeCipherSuites(cipherSuites.toArray(new String[0]));
                }
                if (!(excludedCipherSuites = this.config.getList("ssl.cipher.suites.exclude")).isEmpty()) {
                    sslContextFactory.setExcludeCipherSuites(cipherSuites.toArray(new String[0]));
                }
                if (!this.config.getString("ssl.endpoint.identification.algorithm").isEmpty()) {
                    sslContextFactory.setEndpointIdentificationAlgorithm(this.config.getString("ssl.endpoint.identification.algorithm"));
                }
                if (!this.config.getString("ssl.truststore.location").isEmpty()) {
                    sslContextFactory.setTrustStorePath(this.config.getString("ssl.truststore.location"));
                    sslContextFactory.setTrustStorePassword(this.config.getPassword("ssl.truststore.password").value());
                    sslContextFactory.setTrustStoreType(this.config.getString("ssl.truststore.type"));
                    if (!this.config.getString("ssl.trustmanager.algorithm").isEmpty()) {
                        sslContextFactory.setTrustManagerFactoryAlgorithm(this.config.getString("ssl.trustmanager.algorithm"));
                    }
                }
                sslContextFactory.setProtocol(this.config.getString("ssl.protocol"));
                if (!this.config.getString("ssl.provider").isEmpty()) {
                    sslContextFactory.setProtocol(this.config.getString("ssl.provider"));
                }
                connector = new NetworkTrafficServerConnector(this.server, sslContextFactory);
            }
            connector.addNetworkTrafficListener((NetworkTrafficListener)metricsListener);
            connector.setPort(listener.getPort());
            connector.setHost(listener.getHost());
            this.server.addConnector((Connector)connector);
        }
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder defaultHolder = new ServletHolder("default", DefaultServlet.class);
        defaultHolder.setInitParameter("dirAllowed", "false");
        ResourceCollection staticResources = this.getStaticResources();
        if (staticResources != null) {
            context.setBaseResource((Resource)staticResources);
        }
        if (this.config.getBoolean("compression.enable")) {
            FilterHolder gzipFilter = new FilterHolder(AsyncGzipFilter.class);
            gzipFilter.setInitParameter("checkGzExists", "false");
            gzipFilter.setInitParameter("methods", "GET,POST");
            context.addFilter(gzipFilter, "/*", null);
        }
        if (Application.enableBasicAuth(authMethod = this.config.getString("authentication.method"))) {
            String realm = this.getConfiguration().getString("authentication.realm");
            List roles = this.getConfiguration().getList("authentication.roles");
            ConstraintSecurityHandler securityHandler = Application.createSecurityHandler(realm, roles);
            context.setSecurityHandler((SecurityHandler)securityHandler);
        }
        if ((allowedOrigins = this.getConfiguration().getString("access.control.allow.origin")) != null && !allowedOrigins.trim().isEmpty()) {
            FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.getConfiguration().getString("access.control.allow.methods");
            if (allowedMethods != null && !allowedOrigins.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        context.addFilter(servletHolder, "/*", null);
        this.configurePostResourceHandling(context);
        context.addServlet(defaultHolder, "/*");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setLoggerName(this.config.getString("request.logger.name"));
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler(), requestLogHandler});
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        this.server.setHandler((Handler)statsHandler);
        int gracefulShutdownMs = this.getConfiguration().getInt("shutdown.graceful.ms");
        if (gracefulShutdownMs > 0) {
            this.server.setStopTimeout((long)gracefulShutdownMs);
        }
        this.server.setStopAtShutdown(true);
        return this.server;
    }

    static boolean enableBasicAuth(String authMethod) {
        return "BASIC".equals(authMethod);
    }

    static ConstraintSecurityHandler createSecurityHandler(String realm, List<String> roles) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**"});
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setMethod("*");
        constraintMapping.setPathSpec("/*");
        securityHandler.addConstraintMapping(constraintMapping);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setLoginService((LoginService)new JAASLoginService(realm));
        securityHandler.setIdentityService((IdentityService)new DefaultIdentityService());
        securityHandler.setRealmName(realm);
        securityHandler.setDenyUncoveredHttpMethods(false);
        securityHandler.addRole("*");
        return securityHandler;
    }

    public static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        if (listenersConfig.isEmpty() || listenersConfig.get(0).isEmpty()) {
            log.warn("DEPRECATION warning: `listeners` configuration is not configured. Falling back to the deprecated `port` configuration.");
            listenersConfig = new ArrayList<String>(1);
            listenersConfig.add(defaultScheme + "://0.0.0.0:" + deprecatedPort);
        }
        ArrayList<URI> listeners = new ArrayList<URI>(listenersConfig.size());
        for (String listenerStr : listenersConfig) {
            URI uri;
            try {
                uri = new URI(listenerStr);
            }
            catch (URISyntaxException use) {
                throw new ConfigException("Could not parse a listener URI from the `listener` configuration option.");
            }
            String scheme = uri.getScheme();
            if (scheme == null) {
                throw new ConfigException("Found a listener without a scheme. All listeners must have a scheme. The listener without a scheme is: " + listenerStr);
            }
            if (uri.getPort() == -1) {
                throw new ConfigException("Found a listener without a port. All listeners must have a port. The listener without a port is: " + listenerStr);
            }
            if (!supportedSchemes.contains(scheme)) {
                log.warn("Found a listener with an unsupported scheme (supported: {}). Ignoring listener '{}'", supportedSchemes, (Object)listenerStr);
                continue;
            }
            listeners.add(uri);
        }
        if (listeners.isEmpty()) {
            throw new ConfigException("No listeners are configured. Must have at least one listener.");
        }
        return listeners;
    }

    public void configureBaseApplication(Configurable<?> config) {
        this.configureBaseApplication(config, null);
    }

    public void configureBaseApplication(Configurable<?> config, Map<String, String> metricTags) {
        T restConfig = this.getConfiguration();
        this.registerJsonProvider(config, restConfig, true);
        this.registerFeatures(config, restConfig);
        this.registerExceptionMappers(config, restConfig);
        config.register((Object)new MetricsResourceMethodApplicationListener(this.metrics, "jersey", metricTags, ((RestConfig)((Object)restConfig)).getTime()));
        config.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
    }

    protected void registerJsonProvider(Configurable<?> config, T restConfig, boolean registerExceptionMapper) {
        ObjectMapper jsonMapper = this.getJsonMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        config.register((Object)jsonProvider);
        if (registerExceptionMapper) {
            config.register(JsonParseExceptionMapper.class);
        }
    }

    protected void registerFeatures(Configurable<?> config, T restConfig) {
        config.register(ValidationFeature.class);
    }

    protected void registerExceptionMappers(Configurable<?> config, T restConfig) {
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)((Object)restConfig)));
        config.register((Object)new GenericExceptionMapper((RestConfig)((Object)restConfig)));
    }

    public T getConfiguration() {
        return this.config;
    }

    protected ObjectMapper getJsonMapper() {
        return new ObjectMapper();
    }

    public void start() throws Exception {
        if (this.server == null) {
            this.createServer();
        }
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
        this.shutdownLatch.await();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void onShutdown() {
    }
}

